package cdm.event.common.functions;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.event.common.BusinessEvent;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Qualify_Adjustment.Qualify_AdjustmentDefault.class)
public abstract class Qualify_Adjustment implements RosettaFunction,IQualifyFunctionExtension<BusinessEvent> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractAfterTradableProduct extractAfterTradableProduct;
	@Inject protected ExtractBeforeEconomicTerms extractBeforeEconomicTerms;
	@Inject protected ExtractBeforeTradableProduct extractBeforeTradableProduct;
	@Inject protected ExtractOpenEconomicTerms extractOpenEconomicTerms;
	@Inject protected ExtractTradeCollateralPrice extractTradeCollateralPrice;
	@Inject protected ExtractTradeCollateralQuantity extractTradeCollateralQuantity;
	@Inject protected ExtractTradePurchasePrice extractTradePurchasePrice;

	/**
	* @param businessEvent 
	* @return is_event 
	*/
	@Override
	public Boolean evaluate(BusinessEvent businessEvent) {
		Boolean is_event = doEvaluate(businessEvent);
		
		return is_event;
	}

	protected abstract Boolean doEvaluate(BusinessEvent businessEvent);

	protected abstract Mapper<? extends TradableProduct> beforeTradableProduct(BusinessEvent businessEvent);

	protected abstract Mapper<? extends TradableProduct> afterTradableProduct(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> beforeTradePurchasePrice(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> afterTradePurchasePrice(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> beforeTradeCollateralQuantity(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> afterTradeCollateralQuantity(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> beforeTradeCollateralPrice(BusinessEvent businessEvent);

	protected abstract Mapper<BigDecimal> afterTradeCollateralPrice(BusinessEvent businessEvent);

	protected abstract Mapper<? extends EconomicTerms> beforeEconomicterms(BusinessEvent businessEvent);

	protected abstract Mapper<? extends EconomicTerms> openEconomicTerms(BusinessEvent businessEvent);

	public static class Qualify_AdjustmentDefault extends Qualify_Adjustment {
		@Override
		protected Boolean doEvaluate(BusinessEvent businessEvent) {
			Boolean is_event = null;
			return assignOutput(is_event, businessEvent);
		}
		
		protected Boolean assignOutput(Boolean is_event, BusinessEvent businessEvent) {
			is_event = exists(MapperS.of(businessEvent).<TradeState>mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout())).and(areEqual(MapperS.of(openEconomicTerms(businessEvent).get()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()), MapperS.of(beforeEconomicterms(businessEvent).get()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()), CardinalityOperator.All)).and(exists(MapperC.<BigDecimal>of(beforeTradePurchasePrice(businessEvent).getMulti()))).and(exists(MapperC.<BigDecimal>of(afterTradePurchasePrice(businessEvent).getMulti()))).and(areEqual(MapperC.<BigDecimal>of(afterTradePurchasePrice(businessEvent).getMulti()), MapperC.<BigDecimal>of(beforeTradePurchasePrice(businessEvent).getMulti()), CardinalityOperator.All)).and(notEqual(MapperC.<BigDecimal>of(beforeTradeCollateralQuantity(businessEvent).getMulti()), MapperC.<BigDecimal>of(afterTradeCollateralQuantity(businessEvent).getMulti()), CardinalityOperator.Any)).and(notEqual(MapperC.<BigDecimal>of(beforeTradeCollateralPrice(businessEvent).getMulti()), MapperC.<BigDecimal>of(afterTradeCollateralPrice(businessEvent).getMulti()), CardinalityOperator.Any)).and(exists(MapperS.of(beforeEconomicterms(businessEvent).get()))).and(exists(MapperS.of(openEconomicTerms(businessEvent).get()))).and(areEqual(MapperS.of(openEconomicTerms(businessEvent).get()).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()), MapperS.of(beforeEconomicterms(businessEvent).get()).<AdjustableOrRelativeDate>map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()), CardinalityOperator.All)).and(notEqual(MapperS.of(openEconomicTerms(businessEvent).get()).<AdjustableOrRelativeDate>map("getEffectiveDate", economicTerms -> economicTerms.getEffectiveDate()), MapperS.of(beforeEconomicterms(businessEvent).get()).<AdjustableOrRelativeDate>map("getEffectiveDate", economicTerms -> economicTerms.getEffectiveDate()), CardinalityOperator.Any)).get();
			
			return is_event;
		}
		
		@Override
		protected Mapper<? extends TradableProduct> beforeTradableProduct(BusinessEvent businessEvent) {
			return MapperS.of(extractBeforeTradableProduct.evaluate(MapperS.of(businessEvent).get()));
		}
		
		@Override
		protected Mapper<? extends TradableProduct> afterTradableProduct(BusinessEvent businessEvent) {
			return MapperS.of(extractAfterTradableProduct.evaluate(MapperS.of(businessEvent).get()));
		}
		
		@Override
		protected Mapper<BigDecimal> beforeTradePurchasePrice(BusinessEvent businessEvent) {
			return MapperC.<BigDecimal>of(extractTradePurchasePrice.evaluate(MapperS.of(beforeTradableProduct(businessEvent).get()).get()));
		}
		
		@Override
		protected Mapper<BigDecimal> afterTradePurchasePrice(BusinessEvent businessEvent) {
			return MapperC.<BigDecimal>of(extractTradePurchasePrice.evaluate(MapperS.of(afterTradableProduct(businessEvent).get()).get()));
		}
		
		@Override
		protected Mapper<BigDecimal> beforeTradeCollateralQuantity(BusinessEvent businessEvent) {
			return MapperC.<BigDecimal>of(extractTradeCollateralQuantity.evaluate(MapperS.of(beforeTradableProduct(businessEvent).get()).get()));
		}
		
		@Override
		protected Mapper<BigDecimal> afterTradeCollateralQuantity(BusinessEvent businessEvent) {
			return MapperC.<BigDecimal>of(extractTradeCollateralQuantity.evaluate(MapperS.of(afterTradableProduct(businessEvent).get()).get()));
		}
		
		@Override
		protected Mapper<BigDecimal> beforeTradeCollateralPrice(BusinessEvent businessEvent) {
			return MapperC.<BigDecimal>of(extractTradeCollateralPrice.evaluate(MapperS.of(beforeTradableProduct(businessEvent).get()).get()));
		}
		
		@Override
		protected Mapper<BigDecimal> afterTradeCollateralPrice(BusinessEvent businessEvent) {
			return MapperC.<BigDecimal>of(extractTradeCollateralPrice.evaluate(MapperS.of(afterTradableProduct(businessEvent).get()).get()));
		}
		
		@Override
		protected Mapper<? extends EconomicTerms> beforeEconomicterms(BusinessEvent businessEvent) {
			return MapperS.of(extractBeforeEconomicTerms.evaluate(MapperS.of(businessEvent).get()));
		}
		
		@Override
		protected Mapper<? extends EconomicTerms> openEconomicTerms(BusinessEvent businessEvent) {
			return MapperS.of(extractOpenEconomicTerms.evaluate(MapperS.of(businessEvent).get()));
		}
	}
		
		@Override
		public String getNamePrefix() {
			return "Qualify";
		}
}
