package cdm.base.datetime.validation;

import cdm.base.datetime.RelativeDates;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.joining;

public class RelativeDatesTypeFormatValidator implements Validator<RelativeDates> {

	@Override
	public ValidationResult<RelativeDates> validate(RosettaPath path, RelativeDates o) {
		String error = 
			Lists.<ComparisonResult>newArrayList(
				checkNumber("periodMultiplier", o.getPeriodMultiplier(), empty(), of(0), empty(), empty()), 
				checkNumber("periodSkip", o.getPeriodSkip(), empty(), of(0), empty(), empty())
			).stream().filter(res -> !res.get()).map(res -> res.getError()).collect(joining("; "));
		
		if (!isNullOrEmpty(error)) {
			return failure("RelativeDates", ValidationType.TYPE_FORMAT, "RelativeDates", path, "", error);
		}
		return success("RelativeDates", ValidationType.TYPE_FORMAT, "RelativeDates", path, "");
	}

}
