/*
 * Decompiled with CFR 0.152.
 */
package org.fhir.ucum;

import org.fhir.ucum.Component;
import org.fhir.ucum.ConceptKind;
import org.fhir.ucum.DefinedUnit;
import org.fhir.ucum.Factor;
import org.fhir.ucum.Lexer;
import org.fhir.ucum.Operator;
import org.fhir.ucum.Prefix;
import org.fhir.ucum.Symbol;
import org.fhir.ucum.Term;
import org.fhir.ucum.TokenType;
import org.fhir.ucum.UcumException;
import org.fhir.ucum.UcumModel;
import org.fhir.ucum.Unit;

public class ExpressionParser {
    private UcumModel model;

    public ExpressionParser(UcumModel model) {
        this.model = model;
    }

    public Term parse(String code) throws UcumException {
        Lexer lexer = new Lexer(code);
        Term res = this.parseTerm(lexer, true);
        if (!lexer.finished()) {
            throw new UcumException("Expression was not parsed completely. Syntax Error?");
        }
        return res;
    }

    private Term parseTerm(Lexer lexer, boolean first) throws UcumException {
        Term res = new Term();
        if (first && lexer.getType() == TokenType.NONE) {
            res.setComp(new Factor(1));
        } else if (lexer.getType() == TokenType.SOLIDUS) {
            res.setOp(Operator.DIVISION);
            lexer.consume();
            res.setTerm(this.parseTerm(lexer, false));
        } else {
            if (lexer.getType() == TokenType.ANNOTATION) {
                res.setComp(new Factor(1));
                lexer.consume();
            } else {
                res.setComp(this.parseComp(lexer));
            }
            if (lexer.getType() != TokenType.NONE && lexer.getType() != TokenType.CLOSE) {
                if (lexer.getType() == TokenType.SOLIDUS) {
                    res.setOp(Operator.DIVISION);
                    lexer.consume();
                } else if (lexer.getType() == TokenType.PERIOD) {
                    res.setOp(Operator.MULTIPLICATION);
                    lexer.consume();
                } else if (lexer.getType() == TokenType.ANNOTATION) {
                    res.setOp(Operator.MULTIPLICATION);
                } else {
                    lexer.error("Expected '/' or '.'");
                }
                res.setTerm(this.parseTerm(lexer, false));
            }
        }
        return res;
    }

    private Component parseComp(Lexer lexer) throws UcumException {
        if (lexer.getType() == TokenType.NUMBER) {
            Factor fact = new Factor(lexer.getTokenAsInt());
            lexer.consume();
            return fact;
        }
        if (lexer.getType() == TokenType.SYMBOL) {
            return this.parseSymbol(lexer);
        }
        if (lexer.getType() == TokenType.NONE) {
            lexer.error("unexpected end of expression looking for a symbol or a number");
        } else {
            if (lexer.getType() == TokenType.OPEN) {
                lexer.consume();
                Term res = this.parseTerm(lexer, true);
                if (lexer.getType() == TokenType.CLOSE) {
                    lexer.consume();
                } else {
                    lexer.error("Unexpected Token Type '" + lexer.getType().toString() + "' looking for a close bracket");
                }
                return res;
            }
            lexer.error("unexpected token looking for a symbol or a number");
        }
        return null;
    }

    private Component parseSymbol(Lexer lexer) throws UcumException {
        Symbol symbol = new Symbol();
        String sym = lexer.getToken();
        Prefix selected = null;
        Unit unit = null;
        for (Prefix prefix : this.model.getPrefixes()) {
            if (!sym.startsWith(prefix.getCode()) || (unit = this.model.getUnit(sym.substring(prefix.getCode().length()))) == null || unit.getKind() != ConceptKind.BASEUNIT && !((DefinedUnit)unit).isMetric()) continue;
            selected = prefix;
            break;
        }
        if (selected != null) {
            symbol.setPrefix(selected);
            symbol.setUnit(unit);
        } else {
            unit = this.model.getUnit(sym);
            if (unit != null) {
                symbol.setUnit(unit);
            } else if (!sym.equals("1")) {
                lexer.error("The unit '" + sym + "' is unknown");
            }
        }
        lexer.consume();
        if (lexer.getType() == TokenType.NUMBER) {
            symbol.setExponent(lexer.getTokenAsInt());
            lexer.consume();
        } else {
            symbol.setExponent(1);
        }
        return symbol;
    }
}

