/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.store.JdbcFeatureStoreConstants;
import org.ff4j.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.transaction.annotation.Transactional;

public class FeatureStoreSpringJDBC
implements JdbcFeatureStoreConstants,
FeatureStore {
    private static final FlippingPointRowMapper MAPPER = new FlippingPointRowMapper();
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;

    public void enable(String featId) {
        if (!this.exist(featId)) {
            throw new FeatureNotFoundException(featId);
        }
        this.getJdbcTemplate().update("UPDATE FF4J_FEATURES SET ENABLE = 1 WHERE UID = ?", new Object[]{featId});
    }

    public void disable(String featId) {
        if (!this.exist(featId)) {
            throw new FeatureNotFoundException(featId);
        }
        this.getJdbcTemplate().update("UPDATE FF4J_FEATURES SET ENABLE = 0 WHERE UID = ?", new Object[]{featId});
    }

    public boolean exist(String featId) {
        return 1 == this.getJdbcTemplate().queryForInt("SELECT COUNT(UID) FROM FF4J_FEATURES WHERE UID = ?", new Object[]{featId});
    }

    public Feature read(String featId) {
        List dbFlips = this.getJdbcTemplate().query("SELECT UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM FF4J_FEATURES WHERE UID = ?", (RowMapper)MAPPER, new Object[]{featId});
        if (dbFlips.isEmpty()) {
            throw new FeatureNotFoundException(featId);
        }
        Feature fp = (Feature)dbFlips.get(0);
        List auths = this.getJdbcTemplate().query("SELECT ROLE_NAME FROM FF4J_ROLES WHERE FEAT_UID = ?", (RowMapper)new SingleColumnRowMapper(), new Object[]{featId});
        fp.getAuthorizations().addAll(auths);
        return (Feature)dbFlips.get(0);
    }

    @Transactional
    public void create(Feature fp) {
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        String strategyColumn = null;
        String expressionColumn = null;
        if (fp.getFlippingStrategy() != null) {
            strategyColumn = fp.getFlippingStrategy().getClass().getCanonicalName();
            expressionColumn = ParameterUtils.fromMap((Map)fp.getFlippingStrategy().getInitParams());
        }
        this.getJdbcTemplate().update("INSERT INTO FF4J_FEATURES(UID, ENABLE, DESCRIPTION, STRATEGY,EXPRESSION, GROUPNAME) VALUES(?, ?, ?, ?, ?, ?)", new Object[]{fp.getUid(), fp.isEnable() ? 1 : 0, fp.getDescription(), strategyColumn, expressionColumn, fp.getGroup()});
        if (fp.getAuthorizations() != null) {
            for (String role : fp.getAuthorizations()) {
                this.getJdbcTemplate().update("INSERT INTO FF4J_ROLES(FEAT_UID, ROLE_NAME) VALUES (?,?)", new Object[]{fp.getUid(), role});
            }
        }
    }

    @Transactional
    public void delete(String fpId) {
        if (!this.exist(fpId)) {
            throw new FeatureNotFoundException(fpId);
        }
        Feature fp = this.read(fpId);
        if (fp.getAuthorizations() != null) {
            for (String role : fp.getAuthorizations()) {
                this.getJdbcTemplate().update("DELETE FROM FF4J_ROLES WHERE FEAT_UID = ? AND ROLE_NAME = ?", new Object[]{fp.getUid(), role});
            }
        }
        this.getJdbcTemplate().update("DELETE FROM FF4J_FEATURES WHERE UID = ?", new Object[]{fp.getUid()});
    }

    @Transactional
    public void grantRoleOnFeature(String fpId, String roleName) {
        if (!this.exist(fpId)) {
            throw new FeatureNotFoundException(fpId);
        }
        this.getJdbcTemplate().update("INSERT INTO FF4J_ROLES(FEAT_UID, ROLE_NAME) VALUES (?,?)", new Object[]{fpId, roleName});
    }

    @Transactional
    public void removeRoleFromFeature(String fpId, String roleName) {
        if (!this.exist(fpId)) {
            throw new FeatureNotFoundException(fpId);
        }
        this.getJdbcTemplate().update("DELETE FROM FF4J_ROLES WHERE FEAT_UID = ? AND ROLE_NAME = ?", new Object[]{fpId, roleName});
    }

    public Map<String, Feature> readAll() {
        LinkedHashMap<String, Feature> mapFP = new LinkedHashMap<String, Feature>();
        List lFp = this.getJdbcTemplate().query("SELECT UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM FF4J_FEATURES", (RowMapper)MAPPER);
        for (Feature flipPoint : lFp) {
            mapFP.put(flipPoint.getUid(), flipPoint);
        }
        return mapFP;
    }

    @Transactional
    public void update(Feature fp) {
        Feature fpExist = this.read(fp.getUid());
        String fStrategy = null;
        String fExpression = null;
        if (fp.getFlippingStrategy() != null) {
            fStrategy = fp.getFlippingStrategy().getClass().getCanonicalName();
            fExpression = ParameterUtils.fromMap((Map)fp.getFlippingStrategy().getInitParams());
        }
        String enable = "0";
        if (fp.isEnable()) {
            enable = "1";
        }
        this.getJdbcTemplate().update("UPDATE FF4J_FEATURES SET ENABLE=?,DESCRIPTION=?,STRATEGY=?,EXPRESSION=?,GROUPNAME=? WHERE UID = ?", new Object[]{enable, fp.getDescription(), fStrategy, fExpression, fp.getGroup(), fp.getUid()});
        HashSet toBeDeleted = new HashSet();
        toBeDeleted.addAll(fpExist.getAuthorizations());
        toBeDeleted.removeAll(fp.getAuthorizations());
        for (String roleToBeDelete : toBeDeleted) {
            this.removeRoleFromFeature(fpExist.getUid(), roleToBeDelete);
        }
        HashSet toBeAdded = new HashSet();
        toBeAdded.addAll(fp.getAuthorizations());
        toBeAdded.removeAll(fpExist.getAuthorizations());
        for (String addee : toBeAdded) {
            this.grantRoleOnFeature(fpExist.getUid(), addee);
        }
        if (fp.isEnable() != fpExist.isEnable()) {
            if (fp.isEnable()) {
                this.enable(fp.getUid());
            } else {
                this.disable(fp.getUid());
            }
        }
    }

    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String toString() {
        return "DataBaseFeatureStore [dataSource=" + this.dataSource + "]";
    }

    public JdbcTemplate getJdbcTemplate() {
        if (this.jdbcTemplate == null) {
            if (this.dataSource == null) {
                throw new IllegalStateException("ff4j-jdbc: DatabaseStore has not been properly initialized, datasource is null");
            }
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        }
        return this.jdbcTemplate;
    }

    static class FlippingPointRowMapper
    implements ParameterizedRowMapper<Feature> {
        public Feature mapRow(ResultSet rs, int rowNum) throws SQLException {
            Feature f = new Feature(rs.getString("UID"), rs.getInt("ENABLE") > 0, rs.getString("DESCRIPTION"));
            f.setGroup(rs.getString("GROUPNAME"));
            return f;
        }
    }
}

