/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.util.Collection;
import org.ff4j.audit.EventQueryDefinition;

public class JdbcQueryBuilder {
    public String tablePrefix = "FF4J_";
    public String tableSuffix = "";
    private String dbSchema;

    public JdbcQueryBuilder() {
    }

    public JdbcQueryBuilder(String prefix, String suffix) {
        this.tablePrefix = prefix;
        this.tableSuffix = suffix;
    }

    public JdbcQueryBuilder(String prefix, String suffix, String schema) {
        this.tablePrefix = prefix;
        this.tableSuffix = suffix;
        this.dbSchema = schema;
    }

    public String getTableName(String coreName) {
        return this.tablePrefix + coreName + this.tableSuffix;
    }

    public String getTableNameAudit() {
        return this.getTableName("AUDIT");
    }

    public String getTableNameFeatures() {
        return this.getTableName("FEATURES");
    }

    public String getTableNameRoles() {
        return this.getTableName("ROLES");
    }

    public String getTableNameCustomProperties() {
        return this.getTableName("CUSTOM_PROPERTIES");
    }

    public String getTableNameProperties() {
        return this.getTableName("PROPERTIES");
    }

    public String sqlCreateTableFeatures() {
        StringBuilder sb = new StringBuilder("CREATE TABLE ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append("( FEAT_UID    VARCHAR(100), ENABLE      INTEGER NOT NULL, DESCRIPTION VARCHAR(1000), STRATEGY    VARCHAR(1000), EXPRESSION  VARCHAR(255), GROUPNAME   VARCHAR(100), PRIMARY KEY(FEAT_UID))");
        return sb.toString();
    }

    public String sqlCreateTableRoles() {
        StringBuilder sb = new StringBuilder("CREATE TABLE ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameRoles());
        sb.append("( FEAT_UID VARCHAR(100) REFERENCES " + this.getTableNameFeatures() + "(FEAT_UID), ROLE_NAME  VARCHAR(100), PRIMARY KEY(FEAT_UID, ROLE_NAME))");
        return sb.toString();
    }

    public String sqlCreateTableCustomProperties() {
        StringBuilder sb = new StringBuilder("CREATE TABLE ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameCustomProperties());
        sb.append("( PROPERTY_ID   VARCHAR(100) NOT NULL, CLAZZ          VARCHAR(255) NOT NULL, CURRENTVALUE  VARCHAR(255), FIXEDVALUES   VARCHAR(1000), DESCRIPTION   VARCHAR(1000), FEAT_UID      VARCHAR(100) REFERENCES " + this.getTableNameFeatures() + "(FEAT_UID), PRIMARY KEY(PROPERTY_ID, FEAT_UID))");
        return sb.toString();
    }

    public String sqlCreateTableProperties() {
        StringBuilder sb = new StringBuilder("CREATE TABLE ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameProperties());
        sb.append("( PROPERTY_ID  VARCHAR(100) NOT NULL, CLAZZ        VARCHAR(255) NOT NULL, CURRENTVALUE VARCHAR(255), FIXEDVALUES  VARCHAR(1000), DESCRIPTION  VARCHAR(1000), PRIMARY KEY(PROPERTY_ID))");
        return sb.toString();
    }

    public String sqlCreateTableAudit() {
        StringBuilder sb = new StringBuilder("CREATE TABLE ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameAudit());
        sb.append("( EVT_UUID    VARCHAR(40)  NOT NULL, EVT_TIME     TIMESTAMP    NOT NULL, EVT_TYPE     VARCHAR(30)  NOT NULL, EVT_NAME     VARCHAR(30)  NOT NULL, EVT_ACTION   VARCHAR(30)  NOT NULL, EVT_HOSTNAME VARCHAR(100) NOT NULL, EVT_SOURCE   VARCHAR(30)  NOT NULL, EVT_DURATION INTEGER, EVT_USER     VARCHAR(30), EVT_VALUE    VARCHAR(100), EVT_KEYS     VARCHAR(255),PRIMARY KEY(EVT_UUID, EVT_TIME))");
        return sb.toString();
    }

    public String getAllFeatures() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT FEAT_UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        return sb.toString();
    }

    public String getAllGroups() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT DISTINCT(GROUPNAME) FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        return sb.toString();
    }

    public String getFeatureOfGroup() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT FEAT_UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append(" WHERE GROUPNAME = ?");
        return sb.toString();
    }

    public String getFeature() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT FEAT_UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append(" WHERE FEAT_UID = ?");
        return sb.toString();
    }

    public String existFeature() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(FEAT_UID) FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append(" WHERE FEAT_UID = ?");
        return sb.toString();
    }

    public String existGroup() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(FEAT_UID) FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append(" WHERE GROUPNAME = ?");
        return sb.toString();
    }

    public String enableFeature() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append(" SET ENABLE = 1 WHERE FEAT_UID = ?");
        return sb.toString();
    }

    public String enableGroup() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append(" SET ENABLE = 1 WHERE GROUPNAME = ?");
        return sb.toString();
    }

    public String disableFeature() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append(" SET ENABLE = 0 WHERE FEAT_UID = ?");
        return sb.toString();
    }

    public String disableGroup() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append(" SET ENABLE = 0 WHERE GROUPNAME = ?");
        return sb.toString();
    }

    public String addFeatureToGroup() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append(" SET GROUPNAME = ? WHERE FEAT_UID = ?");
        return sb.toString();
    }

    public String removeFeatureFromGroup() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append(" SET GROUPNAME = NULL WHERE FEAT_UID = ?");
        return sb.toString();
    }

    public String createFeature() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append("(FEAT_UID, ENABLE, DESCRIPTION, STRATEGY,EXPRESSION, GROUPNAME) VALUES(?, ?, ?, ?, ?, ?)");
        return sb.toString();
    }

    public String deleteFeature() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append(" WHERE FEAT_UID = ?");
        return sb.toString();
    }

    public String updateFeature() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        sb.append(" SET ENABLE=?,DESCRIPTION=?,STRATEGY=?,EXPRESSION=?,GROUPNAME=? WHERE FEAT_UID = ?");
        return sb.toString();
    }

    public String addRoleToFeature() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameRoles());
        sb.append(" (FEAT_UID, ROLE_NAME) VALUES (?,?)");
        return sb.toString();
    }

    public String deleteRoles() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameRoles());
        sb.append(" WHERE FEAT_UID = ?");
        return sb.toString();
    }

    public String deleteFeatureRole() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameRoles());
        sb.append(" WHERE FEAT_UID = ? AND ROLE_NAME = ?");
        return sb.toString();
    }

    public String getRoles() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ROLE_NAME FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameRoles());
        sb.append(" WHERE FEAT_UID = ?");
        return sb.toString();
    }

    public String getAllRoles() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT FEAT_UID,ROLE_NAME FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameRoles());
        return sb.toString();
    }

    public String getFeatureProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT PROPERTY_ID,CLAZZ,CURRENTVALUE,DESCRIPTION,FIXEDVALUES,FEAT_UID FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameCustomProperties());
        sb.append(" WHERE FEAT_UID = ?");
        return sb.toString();
    }

    public String getFeatureProperty() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT PROPERTY_ID,CLAZZ,CURRENTVALUE,FIXEDVALUES,FEAT_UID FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameCustomProperties());
        sb.append(" WHERE PROPERTY_ID = ? AND FEAT_UID = ?");
        return sb.toString();
    }

    public String deleteFeatureProperty() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameCustomProperties());
        sb.append(" WHERE PROPERTY_ID = ? AND FEAT_UID = ?");
        return sb.toString();
    }

    public String deleteAllFeatureCustomProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameCustomProperties());
        sb.append(" WHERE FEAT_UID = ?");
        return sb.toString();
    }

    public String deleteAllCustomProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameCustomProperties());
        return sb.toString();
    }

    public String deleteAllRoles() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameRoles());
        return sb.toString();
    }

    public String deleteAllFeatures() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameFeatures());
        return sb.toString();
    }

    public String createFeatureProperty() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameCustomProperties());
        sb.append("(PROPERTY_ID, CLAZZ, CURRENTVALUE, DESCRIPTION, FIXEDVALUES, FEAT_UID) VALUES(?, ?, ?, ?, ?, ?)");
        return sb.toString();
    }

    public String createProperty() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameProperties());
        sb.append("(PROPERTY_ID, CLAZZ, CURRENTVALUE, DESCRIPTION, FIXEDVALUES) VALUES(?, ?, ?, ?, ?)");
        return sb.toString();
    }

    public String deleteProperty() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameProperties());
        sb.append(" WHERE PROPERTY_ID = ?");
        return sb.toString();
    }

    public String deleteAllProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableName("PROPERTIES"));
        return sb.toString();
    }

    public String existProperty() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(*) FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameProperties());
        sb.append(" WHERE PROPERTY_ID = ?");
        return sb.toString();
    }

    public String getProperty() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT PROPERTY_ID,CLAZZ,CURRENTVALUE,DESCRIPTION,FIXEDVALUES FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameProperties());
        sb.append(" WHERE PROPERTY_ID = ?");
        return sb.toString();
    }

    public String updateProperty() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameProperties());
        sb.append(" SET CURRENTVALUE = ? WHERE PROPERTY_ID = ?");
        return sb.toString();
    }

    public String getAllProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT PROPERTY_ID,CLAZZ,CURRENTVALUE,DESCRIPTION,FIXEDVALUES FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameProperties());
        return sb.toString();
    }

    public String getAllPropertiesNames() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT PROPERTY_ID FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameProperties());
        return sb.toString();
    }

    public String getEventByUuidQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameAudit());
        sb.append(" WHERE EVT_UUID LIKE ?");
        return sb.toString();
    }

    public String getPurgeFeatureUsageQuery(EventQueryDefinition eqd) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameAudit());
        sb.append(this.buildWhereClause(eqd, true, false));
        return sb.toString();
    }

    public String getSelectFeatureUsageQuery(EventQueryDefinition eqd) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameAudit());
        sb.append(this.buildWhereClause(eqd, true, false));
        return sb.toString();
    }

    public String getPurgeAuditTrailQuery(EventQueryDefinition eqd) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameAudit());
        sb.append(this.buildWhereClause(eqd, false, true));
        return sb.toString();
    }

    public String getSelectAuditTrailQuery(EventQueryDefinition eqd) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameAudit());
        sb.append(this.buildWhereClause(eqd, false, true));
        return sb.toString();
    }

    public String getHitCount(String columName) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT count(EVT_UUID) as NB, " + columName + " FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameAudit());
        sb.append(" WHERE (EVT_TYPE LIKE 'feature') ");
        sb.append(" AND   (EVT_ACTION LIKE 'checkOn') ");
        sb.append(" AND   (EVT_TIME> ?) ");
        sb.append(" AND   (EVT_TIME< ?)");
        sb.append(" GROUP BY " + columName);
        return sb.toString();
    }

    public String getFeaturesHitCount() {
        return this.getHitCount("EVT_NAME");
    }

    public String getHostHitCount() {
        return this.getHitCount("EVT_HOSTNAME");
    }

    public String getUserHitCount() {
        return this.getHitCount("EVT_USER");
    }

    public String getSourceHitCount() {
        return this.getHitCount("EVT_SOURCE");
    }

    public String getFeatureDistributionAudit() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT count(EVT_UUID) as NB, EVT_ACTION FROM ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameAudit());
        sb.append(" WHERE (EVT_TYPE LIKE 'feature') ");
        sb.append(" AND   (EVT_NAME LIKE ?) ");
        sb.append(" AND   (EVT_TIME> ?) ");
        sb.append(" AND   (EVT_TIME< ?)");
        sb.append(" GROUP BY EVT_ACTION");
        return sb.toString();
    }

    private String buildClauseIn(Collection<String> elements) {
        boolean first = true;
        StringBuilder sb = new StringBuilder("(");
        for (String el : elements) {
            if (!first) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(el);
            sb.append("'");
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public String buildWhereClause(EventQueryDefinition qDef, boolean filterForCheck, boolean filterAuditTrail) {
        StringBuilder sb = new StringBuilder();
        sb.append(" WHERE (EVT_TIME> ?) ");
        sb.append(" AND   (EVT_TIME< ?) ");
        if (qDef.getActionFilters().isEmpty()) {
            if (filterForCheck) {
                qDef.getActionFilters().add("checkOn");
            }
            if (filterAuditTrail) {
                qDef.getActionFilters().add("connect");
                qDef.getActionFilters().add("disconnect");
                qDef.getActionFilters().add("toggle-on");
                qDef.getActionFilters().add("toggle-off");
                qDef.getActionFilters().add("create");
                qDef.getActionFilters().add("delete");
                qDef.getActionFilters().add("update");
                qDef.getActionFilters().add("clear");
            }
        }
        if (qDef.getActionFilters() != null && !qDef.getActionFilters().isEmpty()) {
            sb.append(" AND (EVT_ACTION IN ");
            sb.append(this.buildClauseIn(qDef.getActionFilters()));
            sb.append(")");
        }
        if (qDef.getHostFilters() != null && !qDef.getHostFilters().isEmpty()) {
            sb.append(" AND (EVT_HOSTNAME IN ");
            sb.append(this.buildClauseIn(qDef.getHostFilters()));
            sb.append(")");
        }
        if (qDef.getNamesFilter() != null && !qDef.getNamesFilter().isEmpty()) {
            sb.append(" AND (EVT_NAME IN ");
            sb.append(this.buildClauseIn(qDef.getNamesFilter()));
            sb.append(")");
        }
        if (qDef.getSourceFilters() != null && !qDef.getSourceFilters().isEmpty()) {
            sb.append(" AND (EVT_SOURCE IN ");
            sb.append(this.buildClauseIn(qDef.getSourceFilters()));
            sb.append(")");
        }
        return sb.toString();
    }

    public String sqlSaveAudit() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(this.getSchemaPattern());
        sb.append(this.getTableNameAudit());
        sb.append("(EVT_UUID, EVT_TIME, EVT_TYPE, EVT_NAME, EVT_ACTION,EVT_HOSTNAME, EVT_SOURCE, EVT_DURATION, EVT_USER, EVT_VALUE, EVT_KEYS) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        return sb.toString();
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    private String getSchemaPattern() {
        String dbSchemaStr = this.getDbSchema();
        if (dbSchemaStr == null || dbSchemaStr.isEmpty()) {
            return "";
        }
        return dbSchemaStr + ".";
    }
}

