/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.strategy.el;

import java.util.HashMap;
import java.util.Map;
import org.ff4j.strategy.el.ExpressionNode;
import org.ff4j.strategy.el.ExpressionOperator;

public final class ExpressionParser {
    private static final char OPEN_BRACKET = '(';
    private static final char CLOSE_BRACKET = ')';
    private static final char OR = ExpressionOperator.OR.getChar();
    private static final char AND = ExpressionOperator.AND.getChar();
    private static final char NOT = ExpressionOperator.NOT.getChar();

    private ExpressionParser() {
    }

    private static ExpressionBracket extractExprWithinParenthesis(String workingExpr) {
        char[] caracteres = workingExpr.toCharArray();
        int offsetOpenBracket = workingExpr.indexOf(40);
        int offsetEnd = offsetOpenBracket + 1;
        int bracketLevel = 0;
        boolean closeBrackFound = false;
        while (!closeBrackFound) {
            if (caracteres[offsetEnd] == '(') {
                ++bracketLevel;
            }
            if (caracteres[offsetEnd] == ')') {
                if (bracketLevel == 0) {
                    closeBrackFound = true;
                }
                --bracketLevel;
            }
            ++offsetEnd;
        }
        String withinBracketExpr = workingExpr.substring(offsetOpenBracket + 1, offsetEnd - 1);
        return new ExpressionBracket(withinBracketExpr, offsetEnd);
    }

    public static ExpressionNode parseExpression(String expressionInput) {
        String initExpr;
        ExpressionNode returnednode = null;
        String expression = expressionInput.replaceAll(" ", "");
        if (!expression.contains(String.valueOf('('))) {
            return ExpressionParser.parseExpressionWithoutParenthesis(expression);
        }
        int idx = 0;
        String workingExpr = initExpr = expression;
        HashMap<String, String> exprMap = new HashMap<String, String>();
        HashMap<String, ExpressionNode> exprNodes = new HashMap<String, ExpressionNode>();
        while (workingExpr.contains(String.valueOf('('))) {
            ExpressionBracket eb = ExpressionParser.extractExprWithinParenthesis(workingExpr);
            exprMap.put("P" + idx, eb.getExpr().replaceAll("\\|", " OR ").replaceAll("\\&", " AND "));
            exprNodes.put("P" + idx, ExpressionParser.parseExpression(eb.getExpr()));
            ++idx;
            if (eb.getOffsetEnd() + 1 <= workingExpr.length()) {
                workingExpr = workingExpr.substring(eb.getOffsetEnd() + 1, workingExpr.length());
                continue;
            }
            workingExpr = "";
        }
        String exp = initExpr.replaceAll("\\|", " OR ").replaceAll("\\&", " AND ");
        for (Map.Entry entr : exprMap.entrySet()) {
            String val = ((String)entr.getValue()).replaceAll("\\(", "\\\\\\(").replaceAll("\\)", "\\\\\\)");
            exp = exp.replaceAll("\\(" + val + "\\)", (String)entr.getKey());
        }
        exp = exp.replaceAll(" AND ", "&").replaceAll(" OR ", "|").replace(" ", "");
        returnednode = ExpressionParser.parseExpressionWithoutParenthesis(exp);
        ExpressionNode tmpNode = new ExpressionNode(returnednode.getOperator());
        tmpNode.getSubNodes().addAll(returnednode.getSubNodes());
        for (ExpressionNode exprNode : returnednode.getSubNodes()) {
            ExpressionParser.processSubstitution(exprNode, tmpNode, exprNodes);
        }
        return tmpNode;
    }

    private static void processSubstitution(ExpressionNode exprNode, ExpressionNode tmpNode, Map<String, ExpressionNode> exprNodes) {
        if (exprNode.getValue() != null && !exprNode.getValue().isEmpty()) {
            if (exprNodes.containsKey(exprNode.getValue())) {
                ExpressionNode storedNode = exprNodes.get(exprNode.getValue());
                tmpNode.getSubNodes().add(storedNode);
                tmpNode.getSubNodes().remove(exprNode);
            }
        } else {
            ExpressionNode subNodeNot = exprNode.getSubNodes().get(0);
            if (exprNodes.containsKey(subNodeNot.getValue())) {
                ExpressionNode notNode = new ExpressionNode(ExpressionOperator.NOT);
                notNode.getSubNodes().add(exprNodes.get(subNodeNot.getValue()));
                tmpNode.getSubNodes().add(notNode);
                tmpNode.getSubNodes().remove(exprNode);
            }
        }
    }

    private static ExpressionNode parseExpressionAndNot(ExpressionNode currentNode, String expr) {
        String[] andOperArray = expr.replaceAll(" ", "").split("\\" + AND);
        if (andOperArray.length > 1) {
            ExpressionNode subNodeAND = new ExpressionNode(ExpressionOperator.AND);
            for (String andOper : andOperArray) {
                if (andOper.startsWith("!")) {
                    ExpressionNode node = new ExpressionNode(ExpressionOperator.NOT);
                    node.getSubNodes().add(new ExpressionNode(andOper.substring(1)));
                    subNodeAND.getSubNodes().add(node);
                    continue;
                }
                subNodeAND.getSubNodes().add(new ExpressionNode(andOper));
            }
            if (currentNode != null) {
                currentNode.getSubNodes().add(subNodeAND);
                return currentNode;
            }
            return subNodeAND;
        }
        if (expr.startsWith("!")) {
            return ExpressionParser.parseOperatorNot(currentNode, expr);
        }
        return ExpressionParser.parseSheet(currentNode, expr);
    }

    private static ExpressionNode parseOperatorNot(ExpressionNode currentNode, String expr) {
        ExpressionNode subNodeNot = new ExpressionNode(ExpressionOperator.NOT);
        subNodeNot.getSubNodes().add(new ExpressionNode(expr.substring(1)));
        if (currentNode == null) {
            return subNodeNot;
        }
        currentNode.getSubNodes().add(subNodeNot);
        return currentNode;
    }

    private static ExpressionNode parseSheet(ExpressionNode currentNode, String expr) {
        if (currentNode == null) {
            return new ExpressionNode(expr);
        }
        currentNode.getSubNodes().add(new ExpressionNode(expr));
        return currentNode;
    }

    private static ExpressionNode parseExpressionWithoutParenthesis(String expr) {
        if (!(expr.contains(String.valueOf(OR)) || expr.contains(String.valueOf(AND)) || expr.contains(String.valueOf(NOT)))) {
            return new ExpressionNode(expr);
        }
        String[] orOperArray = expr.split("\\" + OR);
        ExpressionNode currentNode = null;
        if (orOperArray.length > 1) {
            currentNode = new ExpressionNode(ExpressionOperator.OR);
            for (String oper : orOperArray) {
                currentNode = ExpressionParser.parseExpressionAndNot(currentNode, oper);
            }
        } else {
            currentNode = ExpressionParser.parseExpressionAndNot(null, expr);
        }
        return currentNode;
    }

    private static class ExpressionBracket {
        private final String expr;
        private final int offsetEnd;

        public ExpressionBracket(String e, int o) {
            this.expr = e;
            this.offsetEnd = o;
        }

        public String getExpr() {
            return this.expr;
        }

        public int getOffsetEnd() {
            return this.offsetEnd;
        }
    }
}

