/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import org.ff4j.audit.EventType;

public interface JdbcStoreConstants {
    public static final String SQLQUERY_ALLFEATURES = "SELECT FEAT_UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM FF4J_FEATURES";
    public static final String SQLQUERY_ALLGROUPS = "SELECT DISTINCT(GROUPNAME) FROM FF4J_FEATURES";
    public static final String SQLQUERY_GET_FEATURE_GROUP = "SELECT FEAT_UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM FF4J_FEATURES WHERE GROUPNAME = ?";
    public static final String SQLQUERY_GET_FEATURE_BY_ID = "SELECT FEAT_UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM FF4J_FEATURES WHERE FEAT_UID = ?";
    public static final String SQL_EXIST = "SELECT COUNT(FEAT_UID) FROM FF4J_FEATURES WHERE FEAT_UID = ?";
    public static final String SQL_DISABLE = "UPDATE FF4J_FEATURES SET ENABLE = 0 WHERE FEAT_UID = ?";
    public static final String SQL_ADD_TO_GROUP = "UPDATE FF4J_FEATURES SET GROUPNAME = ? WHERE FEAT_UID = ?";
    public static final String SQL_REMOVE_FROM_GROUP = "UPDATE FF4J_FEATURES SET GROUPNAME = NULL WHERE FEAT_UID = ?";
    public static final String SQL_ENABLE = "UPDATE FF4J_FEATURES SET ENABLE = 1 WHERE FEAT_UID = ?";
    public static final String SQL_ENABLE_GROUP = "UPDATE FF4J_FEATURES SET ENABLE = 1 WHERE GROUPNAME = ?";
    public static final String SQL_DISABLE_GROUP = "UPDATE FF4J_FEATURES SET ENABLE = 0 WHERE GROUPNAME = ?";
    public static final String SQL_EXIST_GROUP = "SELECT COUNT(*) FROM FF4J_FEATURES WHERE GROUPNAME = ?";
    public static final String SQL_CREATE = "INSERT INTO FF4J_FEATURES(FEAT_UID, ENABLE, DESCRIPTION, STRATEGY,EXPRESSION, GROUPNAME) VALUES(?, ?, ?, ?, ?, ?)";
    public static final String SQL_DELETE = "DELETE FROM FF4J_FEATURES WHERE FEAT_UID = ?";
    public static final String SQL_UPDATE = "UPDATE FF4J_FEATURES SET ENABLE=?,DESCRIPTION=?,STRATEGY=?,EXPRESSION=?,GROUPNAME=? WHERE FEAT_UID = ?";
    public static final String SQL_ADD_ROLE = "INSERT INTO FF4J_ROLES(FEAT_UID, ROLE_NAME) VALUES (?,?)";
    public static final String SQL_DELETE_ROLE = "DELETE FROM FF4J_ROLES WHERE FEAT_UID = ? AND ROLE_NAME = ?";
    public static final String SQL_GET_ROLES = "SELECT ROLE_NAME FROM FF4J_ROLES WHERE FEAT_UID = ?";
    public static final String SQL_GET_ALLROLES = "SELECT FEAT_UID,ROLE_NAME FROM FF4J_ROLES";
    public static final String SQL_GET_CUSTOMPROPERTIES_BYFEATUREID = "SELECT PROPERTY_ID,CLAZZ,CURRENTVALUE,DESCRIPTION,FIXEDVALUES,FEAT_UID FROM FF4J_CUSTOM_PROPERTIES WHERE FEAT_UID = ?";
    public static final String SQL_GET_CUSTOMPROPERTY_BYID = "SELECT PROPERTY_ID,CLAZZ,CURRENTVALUE,FIXEDVALUES,FEAT_UID FROM FF4J_CUSTOM_PROPERTIES WHERE PROPERTY_ID = ? AND FEAT_UID = ?";
    public static final String SQL_DELETE_CUSTOMPROPERTY = "DELETE FROM FF4J_CUSTOM_PROPERTIES WHERE PROPERTY_ID = ? AND FEAT_UID = ?";
    public static final String SQL_DELETE_CUSTOMPROPERTIES = "DELETE FROM FF4J_CUSTOM_PROPERTIES WHERE FEAT_UID = ?";
    public static final String SQL_CREATE_CUSTOMPROPERTY = "INSERT INTO FF4J_CUSTOM_PROPERTIES(PROPERTY_ID, CLAZZ, CURRENTVALUE, FIXEDVALUES, FEAT_UID) VALUES(?, ?, ?, ?, ?)";
    public static final String SQL_PROPERTY_CREATE = "INSERT INTO FF4J_PROPERTIES(PROPERTY_ID, CLAZZ, CURRENTVALUE, DESCRIPTION, FIXEDVALUES) VALUES(?, ?, ?, ?, ?)";
    public static final String SQL_PROPERTY_DELETE = "DELETE FROM FF4J_PROPERTIES WHERE PROPERTY_ID = ?";
    public static final String SQL_PROPERTY_EXIST = "SELECT COUNT(*) FROM FF4J_PROPERTIES WHERE PROPERTY_ID = ?";
    public static final String SQL_PROPERTY_READ = "SELECT PROPERTY_ID,CLAZZ,CURRENTVALUE,DESCRIPTION,FIXEDVALUES FROM FF4J_PROPERTIES WHERE PROPERTY_ID = ?";
    public static final String SQL_PROPERTY_UPDATE = "UPDATE FF4J_PROPERTIES SET CURRENTVALUE = ? WHERE PROPERTY_ID = ?";
    public static final String SQL_PROPERTY_READALL = "SELECT PROPERTY_ID,CLAZZ,CURRENTVALUE,DESCRIPTION,FIXEDVALUES,FEAT_UID FROM FF4J_PROPERTIES";
    public static final String TABLE_AUDIT = "FF4J_AUDIT";
    public static final String COL_EVENT_TIME = "EVT_TIME";
    public static final String COL_EVENT_TYPE = "EVT_TYPE";
    public static final String COL_EVENT_UID = "FEAT_UID";
    public static final String SQL_AUDIT_INSERT = "INSERT INTO FF4J_AUDIT(EVT_TIME,EVT_TYPE,FEAT_UID) VALUES (?,?, ?)";
    public static final String SQL_AUDIT_COUNT = "SELECT COUNT(*) FROM FF4J_AUDIT";
    public static final String SQL_AUDIT_LISTFEATURES = "SELECT DISTINCT FEAT_UID FROM FF4J_AUDIT";
    public static final String SQL_AUDIT_COUNTFEATURE = "SELECT COUNT(*) FROM FF4J_AUDIT WHERE (FEAT_UID LIKE ?) AND   (EVT_TYPE LIKE '" + (Object)((Object)EventType.FEATURE_CHECK_ON) + "') " + " AND   (" + "EVT_TIME" + "> ?) " + " AND   (" + "EVT_TIME" + "< ?)";
    public static final String SQL_AUDIT_FEATURE_EVENTOK = "SELECT * FROM FF4J_AUDIT WHERE (FEAT_UID LIKE ?) AND   (EVT_TYPE LIKE '" + (Object)((Object)EventType.FEATURE_CHECK_ON) + "') " + " AND   (" + "EVT_TIME" + "> ?) " + " AND   (" + "EVT_TIME" + "< ?)";
    public static final String SQL_AUDIT_FEATURE_ALLEVENTS = "SELECT * FROM FF4J_AUDIT WHERE (FEAT_UID LIKE ?) AND   (EVT_TIME> ?)  AND   (EVT_TIME< ?)";
    public static final String SQL_AUDIT_DELETE = "DELETE FROM FF4J_AUDIT WHERE (EVT_TIME = ?) AND (EVT_TYPE LIKE ? FEAT_UID)";
    public static final String COL_FEAT_UID = "FEAT_UID";
    public static final String COL_FEAT_ENABLE = "ENABLE";
    public static final String COL_FEAT_DESCRIPTION = "DESCRIPTION";
    public static final String COL_FEAT_GROUPNAME = "GROUPNAME";
    public static final String COL_FEAT_STRATEGY = "STRATEGY";
    public static final String COL_FEAT_EXPRESSION = "EXPRESSION";
    public static final String COL_ROLE_FEATID = "FEAT_UID";
    public static final String COL_ROLE_ROLENAME = "ROLE_NAME";
    public static final String COL_PROPERTY_ID = "PROPERTY_ID";
    public static final String COL_PROPERTY_TYPE = "CLAZZ";
    public static final String COL_PROPERTY_VALUE = "CURRENTVALUE";
    public static final String COL_PROPERTY_FIXED = "FIXEDVALUES";
    public static final String COL_PROPERTY_FEATID = "FEAT_UID";
    public static final String COL_PROPERTY_DESCRIPTION = "DESCRIPTION";
}

