/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ff4j.conf.XmlParser;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.store.AbstractFeatureStore;

public class InMemoryFeatureStore
extends AbstractFeatureStore {
    private String fileName = null;
    private Map<String, Feature> featuresMap = new LinkedHashMap<String, Feature>();
    private Map<String, Set<String>> featureGroups = new HashMap<String, Set<String>>();

    public InMemoryFeatureStore() {
    }

    public InMemoryFeatureStore(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("fileName is required, cannot be null nor empty : the file must exist in classpath");
        }
        this.loadConfFile(fileName);
    }

    public InMemoryFeatureStore(InputStream xmlIN) {
        this.loadConf(xmlIN);
    }

    public InMemoryFeatureStore(Map<String, Feature> maps) {
        this.featuresMap = maps;
        this.buildGroupsFromFeatures();
    }

    private void loadConfFile(String conf) {
        this.fileName = conf;
        this.loadConf(this.getClass().getClassLoader().getResourceAsStream(conf));
    }

    private void loadConf(InputStream xmlIN) {
        if (xmlIN == null) {
            throw new IllegalArgumentException("Cannot parse feature stream");
        }
        this.featuresMap = new XmlParser().parseConfigurationFile(xmlIN).getFeatures();
        this.buildGroupsFromFeatures();
    }

    private void buildGroupsFromFeatures() {
        this.featureGroups = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Feature> item : this.featuresMap.entrySet()) {
            String currentGroup = item.getValue().getGroup();
            if (!this.featureGroups.containsKey(currentGroup)) {
                this.featureGroups.put(currentGroup, new HashSet());
            }
            this.featureGroups.get(currentGroup).add(item.getKey());
        }
    }

    private void updateFeature(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        this.featuresMap.put(fp.getUid(), fp);
        this.buildGroupsFromFeatures();
    }

    @Override
    public void create(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        this.updateFeature(fp);
    }

    @Override
    public void update(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        Feature fpExist = this.read(fp.getUid());
        HashSet<String> toBeAdded = new HashSet<String>();
        toBeAdded.addAll(fp.getPermissions());
        toBeAdded.removeAll(fpExist.getPermissions());
        for (String addee : toBeAdded) {
            this.grantRoleOnFeature(fpExist.getUid(), addee);
        }
        this.updateFeature(fp);
    }

    @Override
    public void delete(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.featuresMap.remove(uid);
        this.buildGroupsFromFeatures();
    }

    @Override
    public void grantRoleOnFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.featuresMap.get(uid).getPermissions().add(roleName);
    }

    @Override
    public void removeRoleFromFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.featuresMap.get(uid).getPermissions().remove(roleName);
    }

    @Override
    public boolean exist(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        return this.featuresMap.containsKey(uid);
    }

    @Override
    public void enable(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.featuresMap.get(uid).enable();
    }

    @Override
    public void disable(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.featuresMap.get(uid).disable();
    }

    @Override
    public Feature read(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        return this.featuresMap.get(uid);
    }

    @Override
    public boolean existGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        return this.featureGroups.containsKey(groupName);
    }

    @Override
    public void enableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        for (String feat : this.featureGroups.get(groupName)) {
            this.enable(feat);
        }
    }

    @Override
    public void disableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        for (String feat : this.featureGroups.get(groupName)) {
            this.disable(feat);
        }
    }

    @Override
    public Map<String, Feature> readGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("groupName cannot be null nor empty");
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        HashMap<String, Feature> features = new HashMap<String, Feature>();
        for (String feat : this.featureGroups.get(groupName)) {
            features.put(feat, this.read(feat));
        }
        return features;
    }

    @Override
    public Set<String> readAllGroups() {
        HashSet<String> groups = new HashSet<String>();
        groups.addAll(this.featureGroups.keySet());
        groups.remove(null);
        groups.remove("");
        return groups;
    }

    @Override
    public void addToGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        Feature feat = this.read(uid);
        feat.setGroup(groupName);
        this.update(feat);
    }

    @Override
    public void removeFromGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        Feature feat = this.read(uid);
        feat.setGroup("");
        this.update(feat);
    }

    @Override
    public Map<String, Feature> readAll() {
        return this.featuresMap;
    }

    public String toString() {
        return this.toJson();
    }

    @Override
    public String toJson() {
        String json = super.toJson();
        json = json.substring(0, json.length() - 1) + ",\"xmlInputFile\":";
        json = null == this.fileName ? json + "null" : json + "\"" + this.fileName + "\"";
        json = json + "}";
        return json;
    }

    public void setLocation(String locations) {
        this.loadConfFile(locations);
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public String getCacheProvider() {
        return null;
    }

    @Override
    public String getCachedTargetStore() {
        return null;
    }
}

