/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.property.store;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ff4j.conf.XmlParser;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.AbstractProperty;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.utils.Util;

public class InMemoryPropertyStore
extends AbstractPropertyStore {
    private Map<String, AbstractProperty<?>> properties = new LinkedHashMap();
    private String fileName;

    public InMemoryPropertyStore() {
    }

    public InMemoryPropertyStore(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("fileName is required, cannot be null nor empty : the file must exist in classpath");
        }
        this.loadConfFile(fileName);
    }

    public InMemoryPropertyStore(InputStream xmlIN) {
        this.loadConf(xmlIN);
    }

    public InMemoryPropertyStore(Map<String, AbstractProperty<?>> maps) {
        this.properties = maps;
    }

    private void loadConfFile(String conf) {
        this.fileName = conf;
        this.loadConf(this.getClass().getClassLoader().getResourceAsStream(conf));
    }

    private void loadConf(InputStream xmlIN) {
        if (xmlIN == null) {
            throw new IllegalArgumentException("Cannot parse stream with properties");
        }
        this.properties = new XmlParser().parseConfigurationFile(xmlIN).getProperties();
    }

    @Override
    public boolean existProperty(String name) {
        Util.assertHasLength(name);
        return this.properties.containsKey(name);
    }

    @Override
    public <T> void createProperty(AbstractProperty<T> value) {
        Util.assertNotNull(value);
        Util.assertHasLength(value.getName());
        if (this.existProperty(value.getName())) {
            throw new PropertyAlreadyExistException(value.getName());
        }
        this.properties.put(value.getName(), value);
    }

    @Override
    public AbstractProperty<?> readProperty(String name) {
        Util.assertHasLength(name);
        if (!this.properties.containsKey(name)) {
            throw new PropertyNotFoundException(name);
        }
        return this.properties.get(name);
    }

    @Override
    public <T> void updateProperty(AbstractProperty<T> newValue) {
        Util.assertNotNull(newValue);
        Util.assertHasLength(newValue.getName());
        if (!this.existProperty(newValue.getName())) {
            throw new PropertyNotFoundException(newValue.getName());
        }
        this.properties.put(newValue.getName(), newValue);
    }

    @Override
    public void updateProperty(String name, String newValue) {
        Util.assertHasLength(name);
        Util.assertHasLength(newValue);
        if (!this.existProperty(name)) {
            throw new PropertyNotFoundException(name);
        }
        AbstractProperty<?> current = this.readProperty(name);
        current.setValueFromString(newValue);
    }

    @Override
    public void deleteProperty(String name) {
        Util.assertHasLength(name);
        if (!this.properties.containsKey(name)) {
            throw new PropertyNotFoundException(name);
        }
        this.properties.remove(name);
    }

    @Override
    public Map<String, AbstractProperty<?>> readAllProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, AbstractProperty<?>> properties) {
        this.properties = properties;
    }

    public void setLocation(String locations) {
        this.loadConfFile(locations);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

