/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.ff4j.audit.EventPublisher;
import org.ff4j.audit.EventType;
import org.ff4j.audit.repository.EventRepository;
import org.ff4j.audit.repository.InMemoryEventRepository;
import org.ff4j.conf.XmlParser;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.core.FlippingExecutionContext;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.property.AbstractProperty;
import org.ff4j.property.store.InMemoryPropertyStore;
import org.ff4j.property.store.PropertyStore;
import org.ff4j.security.AuthorizationsManager;
import org.ff4j.store.InMemoryFeatureStore;

public class FF4j {
    private boolean autocreate = false;
    private boolean enableAudit = false;
    private final long startTime = System.currentTimeMillis();
    private final String version = this.getClass().getPackage().getImplementationVersion();
    private FeatureStore fstore = new InMemoryFeatureStore();
    private PropertyStore pStore = new InMemoryPropertyStore();
    private AuthorizationsManager authorizationsManager = null;
    private EventRepository eventRepository = new InMemoryEventRepository();
    private EventPublisher eventPublisher = null;
    private volatile boolean shutdownEventPublisher;
    private ThreadLocal<FlippingExecutionContext> currentExecutionContext = new ThreadLocal();

    public FF4j() {
    }

    public FF4j(String xmlFile) {
        this.fstore = new InMemoryFeatureStore(xmlFile);
        this.pStore = new InMemoryPropertyStore(xmlFile);
    }

    public FF4j(InputStream xmlFileResourceAsStream) {
        this.fstore = new InMemoryFeatureStore(xmlFileResourceAsStream);
    }

    public boolean check(String featureID) {
        return this.check(featureID, null);
    }

    public boolean check(String featureID, FlippingExecutionContext executionContext) {
        Feature fp = this.getFeature(featureID);
        boolean flipped = fp.isEnable();
        if (flipped && this.getAuthorizationsManager() != null) {
            boolean bl = flipped = flipped && this.isAllowed(fp);
        }
        if (flipped && fp.getFlippingStrategy() != null) {
            flipped = flipped && fp.getFlippingStrategy().evaluate(featureID, this.getFeatureStore(), executionContext);
        }
        this.currentExecutionContext.set(executionContext);
        if (this.isEnableAudit()) {
            this.getEventPublisher().publish(featureID, flipped);
        }
        return flipped;
    }

    public boolean checkOveridingStrategy(String featureID, FlippingStrategy strats) {
        return this.checkOveridingStrategy(featureID, strats, this.currentExecutionContext.get());
    }

    public boolean checkOveridingStrategy(String featureID, FlippingStrategy strats, FlippingExecutionContext executionContext) {
        boolean flipped;
        Feature fp = this.getFeature(featureID);
        boolean bl = flipped = fp.isEnable() && this.isAllowed(fp);
        if (strats != null) {
            boolean bl2 = flipped = flipped && strats.evaluate(featureID, this.getFeatureStore(), executionContext);
        }
        if (this.isEnableAudit()) {
            this.getEventPublisher().publish(featureID, flipped);
        }
        return flipped;
    }

    public boolean isAllowed(Feature featureName) {
        if (this.getAuthorizationsManager() == null) {
            return true;
        }
        if (featureName.getPermissions().isEmpty()) {
            return true;
        }
        Set<String> userRoles = this.getAuthorizationsManager().getCurrentUserPermissions();
        for (String expectedRole : featureName.getPermissions()) {
            if (!userRoles.contains(expectedRole)) continue;
            return true;
        }
        return false;
    }

    public Map<String, Feature> getFeatures() {
        return this.getFeatureStore().readAll();
    }

    public Map<String, AbstractProperty<?>> getProperties() {
        return this.getPropertiesStore().readAllProperties();
    }

    public FF4j enable(String featureID) {
        try {
            this.getFeatureStore().enable(featureID);
        }
        catch (FeatureNotFoundException fnfe) {
            if (this.autocreate) {
                return this.create(new Feature(featureID, true));
            }
            throw fnfe;
        }
        if (this.isEnableAudit()) {
            this.getEventPublisher().publish(featureID, EventType.ENABLE_FEATURE);
        }
        return this;
    }

    public FF4j enableGroup(String groupName) {
        this.getFeatureStore().enableGroup(groupName);
        if (this.isEnableAudit()) {
            this.getEventPublisher().publish(groupName, EventType.ENABLE_FEATUREGROUP);
        }
        return this;
    }

    public FF4j disableGroup(String groupName) {
        this.getFeatureStore().disableGroup(groupName);
        if (this.isEnableAudit()) {
            this.getEventPublisher().publish(groupName, EventType.DISABLE_FEATUREGROUP);
        }
        return this;
    }

    public FF4j createFeature(Feature fp) {
        this.getFeatureStore().create(fp);
        if (this.isEnableAudit()) {
            this.getEventPublisher().publish(fp.getUid(), EventType.CREATE_FEATURE);
        }
        return this;
    }

    public FF4j createProperty(AbstractProperty<?> prop) {
        this.getPropertiesStore().createProperty(prop);
        if (this.isEnableAudit()) {
            this.getEventPublisher().publish(prop.getName(), EventType.CREATE_PROPERTY);
        }
        return this;
    }

    public FF4j createFeature(String featureName, boolean enable, String description) {
        return this.createFeature(new Feature(featureName, enable, description));
    }

    public FF4j createFeature(String featureName, boolean enable) {
        return this.createFeature(featureName, enable, "");
    }

    public FF4j createFeature(String featureName) {
        return this.createFeature(featureName, false, "");
    }

    @Deprecated
    public FF4j create(Feature fp) {
        return this.createFeature(fp);
    }

    @Deprecated
    public FF4j create(String featureName, boolean enable, String description) {
        return this.create(new Feature(featureName, enable, description));
    }

    @Deprecated
    public FF4j create(String featureName, boolean enable) {
        return this.create(featureName, enable, "");
    }

    @Deprecated
    public FF4j create(String featureName) {
        return this.create(featureName, false, "");
    }

    public FF4j disable(String featureID) {
        try {
            this.getFeatureStore().disable(featureID);
        }
        catch (FeatureNotFoundException fnfe) {
            if (this.autocreate) {
                return this.create(new Feature(featureID, false));
            }
            throw fnfe;
        }
        if (this.isEnableAudit()) {
            this.getEventPublisher().publish(featureID, EventType.DISABLE_FEATURE);
        }
        return this;
    }

    public boolean exist(String featureId) {
        return this.getFeatureStore().exist(featureId);
    }

    public Feature getFeature(String featureID) {
        Feature fp = null;
        try {
            fp = this.getFeatureStore().read(featureID);
        }
        catch (FeatureNotFoundException fnfe) {
            if (this.autocreate) {
                fp = new Feature(featureID, false);
                this.getFeatureStore().create(fp);
            }
            throw fnfe;
        }
        return fp;
    }

    public InputStream exportFeatures() throws IOException {
        return new XmlParser().exportFeatures(this.getFeatureStore().readAll());
    }

    public FF4j autoCreate(boolean flag) {
        this.setAutocreate(flag);
        return this;
    }

    public FF4j autoCreate() {
        return this.autoCreate(true);
    }

    public FF4j delete(String fpId) {
        this.getFeatureStore().delete(fpId);
        if (this.isEnableAudit()) {
            this.getEventPublisher().publish(fpId, EventType.DELETE_FEATURE);
        }
        return this;
    }

    public FF4j deleteProperty(String propertyName) {
        this.getPropertiesStore().deleteProperty(propertyName);
        if (this.isEnableAudit()) {
            this.getEventPublisher().publish(propertyName, EventType.DELETE_PROPERTY);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        long uptime = System.currentTimeMillis() - this.startTime;
        long daynumber = new Double(Math.floor(uptime / 86400000L)).longValue();
        long hourNumber = new Double(Math.floor((uptime -= daynumber * 1000L * 3600L * 24L) / 3600000L)).longValue();
        long minutenumber = new Double(Math.floor((uptime -= hourNumber * 1000L * 3600L) / 60000L)).longValue();
        long secondnumber = new Double(Math.floor((uptime -= minutenumber * 1000L * 60L) / 1000L)).longValue();
        sb.append("\"uptime\":\"");
        sb.append(daynumber + " day(s) ");
        sb.append(hourNumber + " hours(s) ");
        sb.append(minutenumber + " minute(s) ");
        sb.append(secondnumber + " seconds\"");
        sb.append(", \"autocreate\":" + this.isAutocreate());
        sb.append(", \"version\": \"" + this.version + "\"");
        sb.append(", \"featuresStore\":");
        sb.append(this.getFeatureStore() == null ? "null" : this.getFeatureStore().toString());
        sb.append(", \"eventRepository\":");
        sb.append(this.getEventRepository() == null ? "null" : this.getEventRepository().toString());
        sb.append(", \"authorizationsManager\":");
        sb.append(this.getAuthorizationsManager() == null ? "null" : this.getAuthorizationsManager().toString());
        sb.append("}");
        return sb.toString();
    }

    @Deprecated
    public FeatureStore getStore() {
        return this.fstore;
    }

    public FeatureStore getFeatureStore() {
        return this.fstore;
    }

    @Deprecated
    public void setStore(FeatureStore fbs) {
        this.fstore = fbs;
    }

    public void setFeatureStore(FeatureStore fbs) {
        this.fstore = fbs;
    }

    public void setAutocreate(boolean autocreate) {
        this.autocreate = autocreate;
    }

    public AuthorizationsManager getAuthorizationsManager() {
        return this.authorizationsManager;
    }

    public void setAuthorizationsManager(AuthorizationsManager authorizationsManager) {
        this.authorizationsManager = authorizationsManager;
    }

    public EventRepository getEventRepository() {
        return this.eventRepository;
    }

    public void setEventRepository(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public EventPublisher getEventPublisher() {
        if (this.eventPublisher == null) {
            this.eventPublisher = new EventPublisher(this.eventRepository);
            this.shutdownEventPublisher = true;
        }
        return this.eventPublisher;
    }

    public boolean isAutocreate() {
        return this.autocreate;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getVersion() {
        return this.version;
    }

    public PropertyStore getPropertiesStore() {
        return this.pStore;
    }

    public void setPropertiesStore(PropertyStore pStore) {
        this.pStore = pStore;
    }

    public FlippingExecutionContext getCurrentContext() {
        FlippingExecutionContext context = this.currentExecutionContext.get();
        if (context == null) {
            context = new FlippingExecutionContext();
            this.currentExecutionContext.set(context);
        }
        return context;
    }

    public void removeCurrentContext() {
        this.currentExecutionContext.remove();
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
    }

    public void setFileName(String fname) {
    }

    public void stop() {
        if (this.eventPublisher != null && this.shutdownEventPublisher) {
            this.eventPublisher.stop();
        }
    }
}

