/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.spi;

import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import java.io.IOException;

public interface Encoder {
    public void encode(Object var1, JsonStream var2) throws IOException;

    public static class StringDoubleEncoder
    extends DoubleEncoder {
        @Override
        public void encodeDouble(double obj, JsonStream stream) throws IOException {
            stream.write(34);
            stream.writeVal(obj);
            stream.write(34);
        }
    }

    public static abstract class DoubleEncoder
    implements ReflectionEncoder {
        @Override
        public void encode(Object obj, JsonStream stream) throws IOException {
            this.encodeDouble((Double)obj, stream);
        }

        @Override
        public Any wrap(Object obj) {
            Double val = (Double)obj;
            return Any.wrap(val);
        }

        public abstract void encodeDouble(double var1, JsonStream var3) throws IOException;
    }

    public static class StringFloatEncoder
    extends FloatEncoder {
        @Override
        public void encodeFloat(float obj, JsonStream stream) throws IOException {
            stream.write(34);
            stream.writeVal(obj);
            stream.write(34);
        }
    }

    public static abstract class FloatEncoder
    implements ReflectionEncoder {
        @Override
        public void encode(Object obj, JsonStream stream) throws IOException {
            this.encodeFloat(((Float)obj).floatValue(), stream);
        }

        @Override
        public Any wrap(Object obj) {
            Float val = (Float)obj;
            return Any.wrap(val.floatValue());
        }

        public abstract void encodeFloat(float var1, JsonStream var2) throws IOException;
    }

    public static class StringLongEncoder
    extends LongEncoder {
        @Override
        public void encodeLong(long obj, JsonStream stream) throws IOException {
            stream.write(34);
            stream.writeVal(obj);
            stream.write(34);
        }
    }

    public static abstract class LongEncoder
    implements ReflectionEncoder {
        @Override
        public void encode(Object obj, JsonStream stream) throws IOException {
            this.encodeLong((Long)obj, stream);
        }

        @Override
        public Any wrap(Object obj) {
            Long val = (Long)obj;
            return Any.wrap(val);
        }

        public abstract void encodeLong(long var1, JsonStream var3) throws IOException;
    }

    public static class StringIntEncoder
    extends IntEncoder {
        @Override
        public void encodeInt(int obj, JsonStream stream) throws IOException {
            stream.write(34);
            stream.writeVal(obj);
            stream.write(34);
        }
    }

    public static abstract class IntEncoder
    implements ReflectionEncoder {
        @Override
        public void encode(Object obj, JsonStream stream) throws IOException {
            this.encodeInt((Integer)obj, stream);
        }

        @Override
        public Any wrap(Object obj) {
            Integer val = (Integer)obj;
            return Any.wrap(val);
        }

        public abstract void encodeInt(int var1, JsonStream var2) throws IOException;
    }

    public static class StringShortEncoder
    extends ShortEncoder {
        @Override
        public void encodeShort(short obj, JsonStream stream) throws IOException {
            stream.write(34);
            stream.writeVal(obj);
            stream.write(34);
        }
    }

    public static abstract class ShortEncoder
    implements ReflectionEncoder {
        @Override
        public void encode(Object obj, JsonStream stream) throws IOException {
            this.encodeShort((Short)obj, stream);
        }

        @Override
        public Any wrap(Object obj) {
            Short val = (Short)obj;
            return Any.wrap(val.shortValue());
        }

        public abstract void encodeShort(short var1, JsonStream var2) throws IOException;
    }

    public static abstract class BooleanEncoder
    implements Encoder {
        @Override
        public void encode(Object obj, JsonStream stream) throws IOException {
            this.encodeBoolean((Boolean)obj, stream);
        }

        public abstract void encodeBoolean(boolean var1, JsonStream var2) throws IOException;
    }

    public static interface ReflectionEncoder
    extends Encoder {
        public Any wrap(Object var1);
    }
}

