/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.CodegenAccess;
import com.jsoniter.IterImpl;
import com.jsoniter.IterImplNumber;
import com.jsoniter.IterImplSkip;
import com.jsoniter.IterImplString;
import com.jsoniter.JsonIterator;
import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.Slice;
import java.io.IOException;

class IterImplForStreaming {
    IterImplForStreaming() {
    }

    public static final int readObjectFieldAsHash(JsonIterator iter) throws IOException {
        if (IterImplForStreaming.nextToken(iter) != 34) {
            throw iter.reportError("readObjectFieldAsHash", "expect \"");
        }
        long hash = -2128831035L;
        do {
            int i;
            int c = 0;
            for (i = iter.head; i < iter.tail && (c = iter.buf[i]) != 34; ++i) {
                hash ^= (long)c;
                hash *= 16777619L;
            }
            if (c != 34) continue;
            iter.head = i + 1;
            if (IterImplForStreaming.nextToken(iter) != 58) {
                throw iter.reportError("readObjectFieldAsHash", "expect :");
            }
            return (int)hash;
        } while (IterImplForStreaming.loadMore(iter));
        throw iter.reportError("readObjectFieldAsHash", "unmatched quote");
    }

    public static final Slice readObjectFieldAsSlice(JsonIterator iter) throws IOException {
        boolean notCopied;
        Slice field = IterImplForStreaming.readSlice(iter);
        boolean bl = notCopied = field != null;
        if (CodegenAccess.skipWhitespacesWithoutLoadMore(iter)) {
            if (notCopied) {
                int len = field.tail() - field.head();
                byte[] newBuf = new byte[len];
                System.arraycopy(field.data(), field.head(), newBuf, 0, len);
                field.reset(newBuf, 0, newBuf.length);
            }
            if (!IterImplForStreaming.loadMore(iter)) {
                throw iter.reportError("readObjectFieldAsSlice", "expect : after object field");
            }
        }
        if (iter.buf[iter.head] != 58) {
            throw iter.reportError("readObjectFieldAsSlice", "expect : after object field");
        }
        ++iter.head;
        return field;
    }

    static final void skipArray(JsonIterator iter) throws IOException {
        int level = 1;
        do {
            block6: for (int i = iter.head; i < iter.tail; ++i) {
                switch (iter.buf[i]) {
                    case 34: {
                        iter.head = i + 1;
                        IterImplForStreaming.skipString(iter);
                        i = iter.head - 1;
                        continue block6;
                    }
                    case 91: {
                        ++level;
                        continue block6;
                    }
                    case 93: {
                        if (--level != 0) continue block6;
                        iter.head = i + 1;
                        return;
                    }
                }
            }
        } while (IterImplForStreaming.loadMore(iter));
    }

    static final void skipObject(JsonIterator iter) throws IOException {
        int level = 1;
        do {
            block6: for (int i = iter.head; i < iter.tail; ++i) {
                switch (iter.buf[i]) {
                    case 34: {
                        iter.head = i + 1;
                        IterImplForStreaming.skipString(iter);
                        i = iter.head - 1;
                        continue block6;
                    }
                    case 123: {
                        ++level;
                        continue block6;
                    }
                    case 125: {
                        if (--level != 0) continue block6;
                        iter.head = i + 1;
                        return;
                    }
                }
            }
        } while (IterImplForStreaming.loadMore(iter));
    }

    static final void skipString(JsonIterator iter) throws IOException {
        int end;
        while ((end = IterImplSkip.findStringEnd(iter)) == -1) {
            int j = iter.tail - 1;
            boolean escaped = true;
            while (true) {
                if (j < iter.head || iter.buf[j] != 92) {
                    escaped = false;
                    break;
                }
                if (--j < iter.head || iter.buf[j] != 92) break;
                --j;
            }
            if (!IterImplForStreaming.loadMore(iter)) {
                throw iter.reportError("skipString", "incomplete string");
            }
            if (!escaped) continue;
            iter.head = 1;
        }
        iter.head = end;
    }

    static final void skipUntilBreak(JsonIterator iter) throws IOException {
        do {
            for (int i = iter.head; i < iter.tail; ++i) {
                byte c = iter.buf[i];
                if (!IterImplSkip.breaks[c]) continue;
                iter.head = i;
                return;
            }
        } while (IterImplForStreaming.loadMore(iter));
        iter.head = iter.tail;
    }

    static final boolean skipNumber(JsonIterator iter) throws IOException {
        boolean dotFound = false;
        do {
            for (int i = iter.head; i < iter.tail; ++i) {
                byte c = iter.buf[i];
                if (c == 46 || c == 101 || c == 69) {
                    dotFound = true;
                    continue;
                }
                if (!IterImplSkip.breaks[c]) continue;
                iter.head = i;
                return dotFound;
            }
        } while (IterImplForStreaming.loadMore(iter));
        iter.head = iter.tail;
        return dotFound;
    }

    static final Slice readSlice(JsonIterator iter) throws IOException {
        byte[] part2;
        if (IterImpl.nextToken(iter) != 34) {
            throw iter.reportError("readSlice", "expect \" for string");
        }
        int end = IterImplString.findSliceEnd(iter);
        if (end != -1) {
            iter.reusableSlice.reset(iter.buf, iter.head, end - 1);
            iter.head = end;
            return iter.reusableSlice;
        }
        byte[] part1 = new byte[iter.tail - iter.head];
        System.arraycopy(iter.buf, iter.head, part1, 0, part1.length);
        while (true) {
            if (!IterImplForStreaming.loadMore(iter)) {
                throw iter.reportError("readSlice", "unmatched quote");
            }
            end = IterImplString.findSliceEnd(iter);
            if (end != -1) break;
            part2 = new byte[part1.length + iter.buf.length];
            System.arraycopy(part1, 0, part2, 0, part1.length);
            System.arraycopy(iter.buf, 0, part2, part1.length, iter.buf.length);
            part1 = part2;
        }
        part2 = new byte[part1.length + end - 1];
        System.arraycopy(part1, 0, part2, 0, part1.length);
        System.arraycopy(iter.buf, 0, part2, part1.length, end - 1);
        iter.head = end;
        iter.reusableSlice.reset(part2, 0, part2.length);
        return iter.reusableSlice;
    }

    static final byte nextToken(JsonIterator iter) throws IOException {
        do {
            block4: for (int i = iter.head; i < iter.tail; ++i) {
                byte c = iter.buf[i];
                switch (c) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        continue block4;
                    }
                    default: {
                        iter.head = i + 1;
                        return c;
                    }
                }
            }
        } while (IterImplForStreaming.loadMore(iter));
        return 0;
    }

    public static final boolean loadMore(JsonIterator iter) throws IOException {
        if (iter.in == null) {
            return false;
        }
        if (iter.skipStartedAt != -1) {
            return IterImplForStreaming.keepSkippedBytesThenRead(iter);
        }
        int n = iter.in.read(iter.buf);
        if (n < 1) {
            if (n == -1) {
                return false;
            }
            throw iter.reportError("loadMore", "read from input stream returned " + n);
        }
        iter.head = 0;
        iter.tail = n;
        return true;
    }

    private static boolean keepSkippedBytesThenRead(JsonIterator iter) throws IOException {
        int n;
        int offset;
        if (iter.skipStartedAt == 0 || iter.skipStartedAt < iter.tail / 2) {
            byte[] newBuf = new byte[iter.buf.length * 2];
            offset = iter.tail - iter.skipStartedAt;
            System.arraycopy(iter.buf, iter.skipStartedAt, newBuf, 0, offset);
            iter.buf = newBuf;
            n = iter.in.read(iter.buf, offset, iter.buf.length - offset);
        } else {
            offset = iter.tail - iter.skipStartedAt;
            System.arraycopy(iter.buf, iter.skipStartedAt, iter.buf, 0, offset);
            n = iter.in.read(iter.buf, offset, iter.buf.length - offset);
        }
        iter.skipStartedAt = 0;
        if (n < 1) {
            if (n == -1) {
                return false;
            }
            throw iter.reportError("loadMore", "read from input stream returned " + n);
        }
        iter.head = offset;
        iter.tail = offset + n;
        return true;
    }

    static final byte readByte(JsonIterator iter) throws IOException {
        if (iter.head == iter.tail && !IterImplForStreaming.loadMore(iter)) {
            throw iter.reportError("readByte", "no more to read");
        }
        return iter.buf[iter.head++];
    }

    public static Any readAny(JsonIterator iter) throws IOException {
        iter.skipStartedAt = iter.head;
        byte c = IterImplForStreaming.nextToken(iter);
        switch (c) {
            case 34: {
                IterImplForStreaming.skipString(iter);
                byte[] copied = IterImplForStreaming.copySkippedBytes(iter);
                return Any.lazyString(copied, 0, copied.length);
            }
            case 116: {
                IterImplForStreaming.skipFixedBytes(iter, 3);
                iter.skipStartedAt = -1;
                return Any.wrap(true);
            }
            case 102: {
                IterImplForStreaming.skipFixedBytes(iter, 4);
                iter.skipStartedAt = -1;
                return Any.wrap(false);
            }
            case 110: {
                IterImplForStreaming.skipFixedBytes(iter, 3);
                iter.skipStartedAt = -1;
                return Any.wrap(null);
            }
            case 91: {
                IterImplForStreaming.skipArray(iter);
                byte[] copied = IterImplForStreaming.copySkippedBytes(iter);
                return Any.lazyArray(copied, 0, copied.length);
            }
            case 123: {
                IterImplForStreaming.skipObject(iter);
                byte[] copied = IterImplForStreaming.copySkippedBytes(iter);
                return Any.lazyObject(copied, 0, copied.length);
            }
        }
        if (IterImplForStreaming.skipNumber(iter)) {
            byte[] copied = IterImplForStreaming.copySkippedBytes(iter);
            return Any.lazyDouble(copied, 0, copied.length);
        }
        byte[] copied = IterImplForStreaming.copySkippedBytes(iter);
        return Any.lazyLong(copied, 0, copied.length);
    }

    private static byte[] copySkippedBytes(JsonIterator iter) {
        int start = iter.skipStartedAt;
        iter.skipStartedAt = -1;
        int end = iter.head;
        byte[] bytes = new byte[end - start];
        System.arraycopy(iter.buf, start, bytes, 0, bytes.length);
        return bytes;
    }

    public static void skipFixedBytes(JsonIterator iter, int n) throws IOException {
        iter.head += n;
        if (iter.head >= iter.tail) {
            int more = iter.head - iter.tail;
            if (!IterImplForStreaming.loadMore(iter)) {
                if (more == 0) {
                    iter.head = iter.tail;
                    return;
                }
                throw iter.reportError("skipFixedBytes", "unexpected end");
            }
            iter.head += more;
        }
    }

    public static int updateStringCopyBound(JsonIterator iter, int bound) {
        if (bound > iter.tail - iter.head) {
            return iter.tail - iter.head;
        }
        return bound;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int readStringSlowPath(JsonIterator iter, int j) throws IOException {
        boolean isExpectingLowSurrogate = false;
        while (true) {
            int bc;
            block29: {
                block28: {
                    if ((bc = IterImplForStreaming.readByte(iter)) == 34) {
                        return j;
                    }
                    if (bc != 92) break block28;
                    bc = IterImplForStreaming.readByte(iter);
                    switch (bc) {
                        case 98: {
                            bc = 8;
                            break block29;
                        }
                        case 116: {
                            bc = 9;
                            break block29;
                        }
                        case 110: {
                            bc = 10;
                            break block29;
                        }
                        case 102: {
                            bc = 12;
                            break block29;
                        }
                        case 114: {
                            bc = 13;
                            break block29;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            break block29;
                        }
                        case 117: {
                            bc = (IterImplString.translateHex(IterImplForStreaming.readByte(iter)) << 12) + (IterImplString.translateHex(IterImplForStreaming.readByte(iter)) << 8) + (IterImplString.translateHex(IterImplForStreaming.readByte(iter)) << 4) + IterImplString.translateHex(IterImplForStreaming.readByte(iter));
                            if (Character.isHighSurrogate((char)bc)) {
                                if (isExpectingLowSurrogate) {
                                    throw new JsonException("invalid surrogate");
                                }
                                isExpectingLowSurrogate = true;
                            } else if (Character.isLowSurrogate((char)bc)) {
                                if (!isExpectingLowSurrogate) throw new JsonException("invalid surrogate");
                                isExpectingLowSurrogate = false;
                            } else if (isExpectingLowSurrogate) {
                                throw new JsonException("invalid surrogate");
                            }
                            break block29;
                        }
                        default: {
                            throw iter.reportError("readStringSlowPath", "invalid escape character: " + bc);
                        }
                    }
                }
                if ((bc & 0x80) != 0) {
                    byte u2 = IterImplForStreaming.readByte(iter);
                    if ((bc & 0xE0) == 192) {
                        bc = ((bc & 0x1F) << 6) + (u2 & 0x3F);
                    } else {
                        byte u3 = IterImplForStreaming.readByte(iter);
                        if ((bc & 0xF0) == 224) {
                            bc = ((bc & 0xF) << 12) + ((u2 & 0x3F) << 6) + (u3 & 0x3F);
                        } else {
                            byte u4 = IterImplForStreaming.readByte(iter);
                            if ((bc & 0xF8) != 240) {
                                throw iter.reportError("readStringSlowPath", "invalid unicode character");
                            }
                            bc = ((bc & 7) << 18) + ((u2 & 0x3F) << 12) + ((u3 & 0x3F) << 6) + (u4 & 0x3F);
                            if (bc >= 65536) {
                                char[] newBuf;
                                if (bc >= 0x110000) {
                                    throw iter.reportError("readStringSlowPath", "invalid unicode character");
                                }
                                int sup = bc - 65536;
                                if (iter.reusableChars.length == j) {
                                    newBuf = new char[iter.reusableChars.length * 2];
                                    System.arraycopy(iter.reusableChars, 0, newBuf, 0, iter.reusableChars.length);
                                    iter.reusableChars = newBuf;
                                }
                                iter.reusableChars[j++] = (char)((sup >>> 10) + 55296);
                                if (iter.reusableChars.length == j) {
                                    newBuf = new char[iter.reusableChars.length * 2];
                                    System.arraycopy(iter.reusableChars, 0, newBuf, 0, iter.reusableChars.length);
                                    iter.reusableChars = newBuf;
                                }
                                iter.reusableChars[j++] = (char)((sup & 0x3FF) + 56320);
                                continue;
                            }
                        }
                    }
                }
            }
            if (iter.reusableChars.length == j) {
                char[] newBuf = new char[iter.reusableChars.length * 2];
                System.arraycopy(iter.reusableChars, 0, newBuf, 0, iter.reusableChars.length);
                iter.reusableChars = newBuf;
            }
            iter.reusableChars[j++] = (char)bc;
        }
    }

    static long readLongSlowPath(JsonIterator iter, long value) throws IOException {
        value = -value;
        long multmin = -922337203685477580L;
        do {
            for (int i = iter.head; i < iter.tail; ++i) {
                int ind = IterImplNumber.intDigits[iter.buf[i]];
                if (ind == -1) {
                    iter.head = i;
                    return value;
                }
                if (value < multmin) {
                    throw iter.reportError("readLongSlowPath", "value is too large for long");
                }
                if ((value = (value << 3) + (value << 1) - (long)ind) < 0L) continue;
                throw iter.reportError("readLongSlowPath", "value is too large for long");
            }
        } while (IterImpl.loadMore(iter));
        iter.head = iter.tail;
        return value;
    }

    static int readIntSlowPath(JsonIterator iter, int value) throws IOException {
        value = -value;
        int multmin = -214748364;
        do {
            for (int i = iter.head; i < iter.tail; ++i) {
                int ind = IterImplNumber.intDigits[iter.buf[i]];
                if (ind == -1) {
                    iter.head = i;
                    return value;
                }
                if (value < multmin) {
                    throw iter.reportError("readIntSlowPath", "value is too large for int");
                }
                if ((value = (value << 3) + (value << 1) - ind) < 0) continue;
                throw iter.reportError("readIntSlowPath", "value is too large for int");
            }
        } while (IterImpl.loadMore(iter));
        iter.head = iter.tail;
        return value;
    }

    public static final double readDoubleSlowPath(JsonIterator iter) throws IOException {
        try {
            numberChars numberChars2 = IterImplForStreaming.readNumber(iter);
            if (numberChars2.charsLength == 0 && iter.whatIsNext() == ValueType.STRING) {
                String possibleInf = iter.readString();
                if ("infinity".equals(possibleInf)) {
                    return Double.POSITIVE_INFINITY;
                }
                if ("-infinity".equals(possibleInf)) {
                    return Double.NEGATIVE_INFINITY;
                }
                throw iter.reportError("readDoubleSlowPath", "expect number but found string: " + possibleInf);
            }
            return Double.valueOf(new String(numberChars2.chars, 0, numberChars2.charsLength));
        }
        catch (NumberFormatException e) {
            throw iter.reportError("readDoubleSlowPath", e.toString());
        }
    }

    public static final numberChars readNumber(JsonIterator iter) throws IOException {
        int j = 0;
        boolean dotFound = false;
        do {
            block5: for (int i = iter.head; i < iter.tail; ++i) {
                if (j == iter.reusableChars.length) {
                    char[] newBuf = new char[iter.reusableChars.length * 2];
                    System.arraycopy(iter.reusableChars, 0, newBuf, 0, iter.reusableChars.length);
                    iter.reusableChars = newBuf;
                }
                byte c = iter.buf[i];
                switch (c) {
                    case 46: 
                    case 69: 
                    case 101: {
                        dotFound = true;
                    }
                    case 43: 
                    case 45: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        iter.reusableChars[j++] = (char)c;
                        continue block5;
                    }
                    default: {
                        iter.head = i;
                        numberChars numberChars2 = new numberChars();
                        numberChars2.chars = iter.reusableChars;
                        numberChars2.charsLength = j;
                        numberChars2.dotFound = dotFound;
                        return numberChars2;
                    }
                }
            }
        } while (IterImpl.loadMore(iter));
        iter.head = iter.tail;
        numberChars numberChars3 = new numberChars();
        numberChars3.chars = iter.reusableChars;
        numberChars3.charsLength = j;
        numberChars3.dotFound = dotFound;
        return numberChars3;
    }

    static final double readDouble(JsonIterator iter) throws IOException {
        return IterImplForStreaming.readDoubleSlowPath(iter);
    }

    static final long readLong(JsonIterator iter, byte c) throws IOException {
        long ind = IterImplNumber.intDigits[c];
        if (ind == 0L) {
            IterImplForStreaming.assertNotLeadingZero(iter);
            return 0L;
        }
        if (ind == -1L) {
            throw iter.reportError("readLong", "expect 0~9");
        }
        return IterImplForStreaming.readLongSlowPath(iter, ind);
    }

    static final int readInt(JsonIterator iter, byte c) throws IOException {
        int ind = IterImplNumber.intDigits[c];
        if (ind == 0) {
            IterImplForStreaming.assertNotLeadingZero(iter);
            return 0;
        }
        if (ind == -1) {
            throw iter.reportError("readInt", "expect 0~9");
        }
        return IterImplForStreaming.readIntSlowPath(iter, ind);
    }

    static void assertNotLeadingZero(JsonIterator iter) throws IOException {
        try {
            byte nextByte = IterImpl.readByte(iter);
            iter.unreadByte();
            int ind2 = IterImplNumber.intDigits[nextByte];
            if (ind2 == -1) {
                return;
            }
            throw iter.reportError("assertNotLeadingZero", "leading zero is invalid");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            iter.head = iter.tail;
            return;
        }
    }

    static class numberChars {
        char[] chars;
        int charsLength;
        boolean dotFound;

        numberChars() {
        }
    }
}

