/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.serialization.BaseFedoraObjectSerializer;
import org.springframework.stereotype.Component;

@Component
public class JcrXmlSerializer
extends BaseFedoraObjectSerializer {
    @Override
    public String getKey() {
        return "jcr/xml";
    }

    @Override
    public String getMediaType() {
        return "application/xml";
    }

    @Override
    public void serialize(FedoraResource obj, OutputStream out, boolean skipBinary, boolean recurse) throws RepositoryException, IOException {
        Node node = obj.getNode();
        node.getSession().exportSystemView(obj.getPath(), out, skipBinary, !recurse);
    }

    @Override
    public void deserialize(Session session, String path, InputStream stream) throws RepositoryException, IOException {
        session.importXML(path, stream, 3);
    }
}

