/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.apix.indexing.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.http.common.HttpOperationFailedException;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.http.entity.ContentType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.fcrepo.camel.processor.EventProcessor;
import org.fcrepo.client.FcrepoLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceIndexingRoutes
extends RouteBuilder {
    static final String ROUTE_TRIGGER_REINDEX = "direct:trigger-reindex";
    static final String ROUTE_INDEX_PREPARE = "direct:index-service-doc";
    static final String ROUTE_EVENT_PROCESOR = "direct:event-processor";
    static final String ROUTE_GET_SERVICE_DOC_URI = "direct:get-servicedoc-uri";
    static final String ROUTE_PERFORM_INDEX = "direct:perform-index";
    static final String ROUTE_PERFORM_DELETE = "direct:perform-delete";
    static final String ROUTE_DELETE_SERVICE_DOC = "direct:delete-service-doc";
    static final String HEADER_SERVICE_DOC = "CamelApixServiceDocument";
    private static final String FCR_DELETE = "http://fedora.info/definitions/v4/event#ResourceDeletion";
    private static final String AS_DELETE = "https://www.w3.org/ns/activitystreams#Delete";
    private static final Logger LOG = LoggerFactory.getLogger(ServiceIndexingRoutes.class);
    private String extensionContainer;
    private String reindexStream;
    private static final EventProcessor EVENT_PROCESSOR = new EventProcessor();
    static final Processor GET_SERVICE_DOC_HEADER = ex -> {
        StringBuilder headers = new StringBuilder();
        for (Map.Entry entry : ex.getIn().getHeaders().entrySet()) {
            headers.append(entry + "\n");
        }
        LOG.debug("Getting serice doc header from " + headers.toString());
        HashSet<String> rawLinkHeaders = new HashSet<String>();
        Object linkHeader = ex.getIn().getHeader("Link");
        if (linkHeader instanceof Collection) {
            rawLinkHeaders.addAll((Collection)linkHeader);
        } else if (linkHeader instanceof String) {
            rawLinkHeaders.add((String)linkHeader);
        }
        List services = rawLinkHeaders.stream().map(FcrepoLink::new).filter(l -> l.getRel().equals("service")).map(l -> l.getUri()).collect(Collectors.toList());
        ex.getIn().setHeader(HEADER_SERVICE_DOC, services);
    };
    private static final Processor SPARQL_UPDATE_PROCESSOR = ex -> {
        ByteArrayOutputStream serializedGraph = new ByteArrayOutputStream();
        String graph = ex.getIn().getHeader("CamelFcrepoNamedGraph").toString();
        Model model = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)model, (InputStream)((InputStream)ex.getIn().getBody(InputStream.class)), (Lang)RDFLanguages.contentTypeToLang((String)ContentType.parse((String)((String)ex.getIn().getHeader("Content-Type", String.class))).getMimeType()));
        model.write((OutputStream)serializedGraph, "N-TRIPLE");
        ex.getIn().setBody((Object)(ServiceIndexingRoutes.deleteGraph(graph) + ";\n" + ServiceIndexingRoutes.insertGraph(serializedGraph.toString("utf8"), graph)));
        ex.getIn().setHeader("CamelHttpMethod", (Object)"POST");
        ex.getIn().setHeader("Content-Type", (Object)"application/sparql-update");
    };
    private static final Processor SPARQL_DELETE_PROCESSOR = ex -> {
        String graph = ex.getIn().getHeader("CamelFcrepoNamedGraph").toString();
        ex.getIn().setBody((Object)ServiceIndexingRoutes.deleteGraph(graph));
        ex.getIn().setHeader("CamelHttpMethod", (Object)"POST");
        ex.getIn().setHeader("Content-Type", (Object)"application/sparql-update");
    };

    public void setExtensionContainer(String path) {
        this.extensionContainer = path;
    }

    public void setReindexStream(String stream) {
        this.reindexStream = stream;
    }

    public void configure() throws Exception {
        ((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from("{{service.index.stream}}").routeId("from-index-stream").to(ROUTE_EVENT_PROCESOR)).filter(PredicateBuilder.not((Predicate)this.header("CamelFcrepoUri").contains((Object)"#"))).choice().when(this.header("CamelFcrepoUri").startsWith((Object)this.extensionContainer)).enrich(ROUTE_TRIGGER_REINDEX, (i, o) -> i)).end().choice().when(PredicateBuilder.or((Predicate)this.header("CamelFcrepoEventType").contains((Object)FCR_DELETE), (Predicate)this.header("CamelFcrepoEventType").contains((Object)AS_DELETE))).to(ROUTE_DELETE_SERVICE_DOC)).otherwise().to(ROUTE_INDEX_PREPARE);
        this.from(ROUTE_EVENT_PROCESOR).routeId("event-processor").process((Processor)EVENT_PROCESSOR);
        this.from("{{service.reindex.stream}}").routeId("from-reindex-stream").to(ROUTE_INDEX_PREPARE);
        ((TryDefinition)((TryDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(ROUTE_GET_SERVICE_DOC_URI).routeId("get-servicedoc-uri").setHeader("CamelHttpMethod", (Expression)this.constant("HEAD"))).setHeader("CamelHttpUri", (Expression)this.header("CamelFcrepoUri"))).setHeader("Accept", (Expression)this.constant("application/n-triples"))).doTry().to("http://get-servicedoc-uri?httpClient=#httpClient")).doCatch(HttpOperationFailedException.class).to("direct:410")).doFinally().process(GET_SERVICE_DOC_HEADER);
        ((RouteDefinition)this.from("direct:410").id("handle-error")).choice().when(e -> ((HttpOperationFailedException)e.getProperty("CamelExceptionCaught", HttpOperationFailedException.class)).getStatusCode() != 410).process(e -> {
            throw (HttpOperationFailedException)e.getProperty("CamelExceptionCaught", HttpOperationFailedException.class);
        });
        ((RouteDefinition)this.from(ROUTE_INDEX_PREPARE).routeId("prepare-for-index").to(ROUTE_GET_SERVICE_DOC_URI)).split((Expression)this.header(HEADER_SERVICE_DOC)).to(ROUTE_PERFORM_INDEX);
        ((RouteDefinition)this.from(ROUTE_DELETE_SERVICE_DOC).routeId("delete-service-doc").to(ROUTE_GET_SERVICE_DOC_URI)).split((Expression)this.header(HEADER_SERVICE_DOC)).to(ROUTE_PERFORM_DELETE);
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(ROUTE_PERFORM_DELETE).routeId("perform-delete").setHeader("CamelFcrepoNamedGraph", (Expression)this.bodyAs(URI.class))).process(SPARQL_DELETE_PROCESSOR)).log(LoggingLevel.DEBUG, LOG, "Deleting service doc of ${headers[CamelFcrepoUri]}")).to("{{triplestore.baseUrl}}");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(ROUTE_PERFORM_INDEX).routeId("perform-index").removeHeaders("CamelHttp*")).setHeader("CamelHttpUri", (Expression)this.bodyAs(URI.class))).setBody((Expression)this.constant(null))).to("http://perform-index")).setHeader("CamelFcrepoNamedGraph", (Expression)this.header("CamelHttpUri"))).removeHeaders("CamelHttp*")).process(SPARQL_UPDATE_PROCESSOR)).log(LoggingLevel.DEBUG, LOG, "Indexing service doc of ${headers[CamelFcrepoUri]}")).to("{{triplestore.baseUrl}}");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(ROUTE_TRIGGER_REINDEX).id("trigger-reindex")).log(LoggingLevel.INFO, LOG, "Triggering reindex to " + this.reindexStream + " due update to extension ${headers[CamelFcrepoUri]}")).removeHeaders("*")).setHeader("Content-Type", (Expression)this.constant("application/json"))).setBody((Expression)this.constant(String.format("[\"%s\"]", this.reindexStream)))).setHeader("CamelHttpMethod", (Expression)this.constant("POST"))).to("{{reindexing.service.uri}}");
    }

    static String deleteGraph(String namedGraph) throws UnsupportedEncodingException {
        return "DELETE WHERE { GRAPH <" + namedGraph + "> {?s ?p ?o}}";
    }

    static String insertGraph(String content, String namedGraph) throws UnsupportedEncodingException {
        return "INSERT DATA { GRAPH <" + namedGraph + "> {" + content + "}}";
    }
}

