/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.saxon.model;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import org.expath.tools.ToolsException;
import org.expath.tools.model.Attribute;
import org.expath.tools.model.Element;
import org.expath.tools.model.Sequence;
import org.expath.tools.saxon.model.SaxonAttribute;
import org.expath.tools.saxon.model.SaxonSequence;
import org.expath.tools.saxon.util.SequenceIteratorFactory;

public class SaxonElement
implements Element {
    private NodeInfo myNode;
    private XPathContext myCtxt;

    public SaxonElement(NodeInfo node, XPathContext ctxt) throws ToolsException {
        if (node == null) {
            throw new ToolsException("the node is null");
        }
        if (node.getNodeKind() != 1) {
            throw new ToolsException("the node is not an element");
        }
        this.myNode = node;
        this.myCtxt = ctxt;
    }

    public String getLocalName() {
        return this.myNode.getLocalPart();
    }

    public String getNamespaceUri() {
        return this.myNode.getURI();
    }

    public String getDisplayName() {
        return this.myNode.getDisplayName();
    }

    public String getAttribute(String local_name) {
        NamePool pool = this.myNode.getConfiguration().getNamePool();
        NameTest pred = new NameTest(2, "", local_name, pool);
        AxisIterator attrs = this.myNode.iterateAxis(2, (Predicate)pred);
        NodeInfo a = attrs.next();
        if (a == null) {
            return null;
        }
        return a.getStringValue();
    }

    public Iterable<Attribute> attributes() {
        AxisIterator it = this.myNode.iterateAxis(2);
        return new AttributeIterable(it);
    }

    public boolean hasNoNsChild() {
        NamePool pool = this.myNode.getConfiguration().getNamePool();
        NamespaceTest no_ns_pred = new NamespaceTest(pool, 1, "");
        NodeInfo next = this.myNode.iterateAxis(3, (Predicate)no_ns_pred).next();
        return next != null;
    }

    public void noOtherNCNameAttribute(String[] names, String[] forbidden_ns) throws ToolsException {
        NodeInfo attr;
        if (names == null) {
            throw new NullPointerException("the names array is null");
        }
        if (forbidden_ns == null) {
            forbidden_ns = new String[]{};
        }
        Object[] sorted_names = this.sortCopy(names);
        Object[] sorted_ns = this.sortCopy(forbidden_ns);
        String elem_name = this.myNode.getDisplayName();
        AxisIterator it = this.myNode.iterateAxis(2);
        while ((attr = it.next()) != null) {
            String attr_name = attr.getDisplayName();
            String ns = attr.getURI();
            if (Arrays.binarySearch(sorted_ns, ns) >= 0) {
                throw new ToolsException("@" + attr_name + " in namespace " + ns + " not allowed on " + elem_name);
            }
            if (!"".equals(ns) || Arrays.binarySearch(sorted_names, attr.getLocalPart()) >= 0) continue;
            throw new ToolsException("@" + attr_name + " not allowed on " + elem_name);
        }
    }

    private String[] sortCopy(String[] array) {
        Object[] sorted = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            sorted[i] = array[i];
        }
        Arrays.sort(sorted);
        return sorted;
    }

    public Sequence getContent() throws ToolsException {
        try {
            return new SaxonSequence(new SequenceIteratorFactory(){

                @Override
                public SequenceIterator newIterator() {
                    return SaxonElement.this.myNode.iterateAxis(3);
                }
            }, this.myCtxt);
        }
        catch (XPathException e) {
            throw new ToolsException(e.getMessage(), (Throwable)e);
        }
    }

    public Iterable<Element> children() {
        AxisIterator it = this.myNode.iterateAxis(3, (Predicate)NodeKindTest.ELEMENT);
        return new ElemIterable(it);
    }

    public Iterable<Element> children(String ns) {
        NamePool pool = this.myNode.getConfiguration().getNamePool();
        NamespaceTest pred = new NamespaceTest(pool, 1, ns);
        AxisIterator it = this.myNode.iterateAxis(3, (Predicate)pred);
        return new ElemIterable(it);
    }

    public QName parseQName(String value) throws ToolsException {
        try {
            NamespaceMap resolver = this.myNode.getAllNamespaces();
            StructuredQName name = StructuredQName.fromLexicalQName((CharSequence)value, (boolean)true, (boolean)false, (NamespaceResolver)resolver);
            return name.toJaxpQName();
        }
        catch (XPathException ex) {
            throw new ToolsException("Error parsing the literal QName: " + value, (Throwable)ex);
        }
    }

    private class ElemIteratorWrapper
    implements Iterator<Element> {
        private final AxisIterator myIter;
        private NodeInfo myNext;

        public ElemIteratorWrapper(AxisIterator it) {
            this.myIter = it;
            this.myNext = it.next();
        }

        @Override
        public boolean hasNext() {
            return this.myNext != null;
        }

        @Override
        public Element next() {
            SaxonElement e;
            if (this.myNext == null) {
                return null;
            }
            try {
                e = new SaxonElement(this.myNext, SaxonElement.this.myCtxt);
            }
            catch (ToolsException ex) {
                throw new RuntimeException("[cannot happen] error building the saxon element", ex);
            }
            this.myNext = this.myIter.next();
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported");
        }
    }

    private class ElemIterable
    implements Iterable<Element> {
        private final Iterator myIter;

        public ElemIterable(AxisIterator it) {
            this.myIter = new ElemIteratorWrapper(it);
        }

        @Override
        public Iterator<Element> iterator() {
            return this.myIter;
        }
    }

    private static class AttributeIteratorWrapper
    implements Iterator<Attribute> {
        private final AxisIterator myIter;
        private NodeInfo myNext;

        public AttributeIteratorWrapper(AxisIterator it) {
            this.myIter = it;
            this.myNext = it.next();
        }

        @Override
        public boolean hasNext() {
            return this.myNext != null;
        }

        @Override
        public Attribute next() {
            if (this.myNext == null) {
                return null;
            }
            SaxonAttribute a = new SaxonAttribute(this.myNext);
            this.myNext = this.myIter.next();
            return a;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported");
        }
    }

    private static class AttributeIterable
    implements Iterable<Attribute> {
        private final Iterator myIter;

        public AttributeIterable(AxisIterator it) {
            this.myIter = new AttributeIteratorWrapper(it);
        }

        @Override
        public Iterator<Attribute> iterator() {
            return this.myIter;
        }
    }
}

