/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.saxon.fun;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import org.expath.tools.saxon.fun.Library;

public class Types {
    public static final int SINGLE = 16384;
    public static final int OPTIONAL = 24576;
    public static final int ANY = 57344;
    public static final int SEVERAL = 49152;
    public static final ItemType ITEM = AnyItemType.getInstance();
    public static final ItemType BASE64 = BuiltInAtomicType.BASE64_BINARY;
    public static final ItemType BOOLEAN = BuiltInAtomicType.BOOLEAN;
    public static final ItemType BYTE = BuiltInAtomicType.BYTE;
    public static final ItemType DATE = BuiltInAtomicType.DATE;
    public static final ItemType DATETIME = BuiltInAtomicType.DATE_TIME;
    public static final ItemType DECIMAL = BuiltInAtomicType.DECIMAL;
    public static final ItemType DOUBLE = BuiltInAtomicType.DOUBLE;
    public static final ItemType FLOAT = BuiltInAtomicType.FLOAT;
    public static final ItemType INT = BuiltInAtomicType.INT;
    public static final ItemType INTEGER = BuiltInAtomicType.INTEGER;
    public static final ItemType LONG = BuiltInAtomicType.LONG;
    public static final ItemType SHORT = BuiltInAtomicType.SHORT;
    public static final ItemType STRING = BuiltInAtomicType.STRING;
    public static final ItemType URI = BuiltInAtomicType.ANY_URI;
    public static final ItemType NODE = AnyNodeTest.getInstance();
    public static final ItemType ATTRIBUTE = NodeKindTest.ATTRIBUTE;
    public static final ItemType COMMENT = NodeKindTest.COMMENT;
    public static final ItemType DOCUMENT = NodeKindTest.DOCUMENT;
    public static final ItemType ELEMENT = NodeKindTest.ELEMENT;
    public static final ItemType NAMESPACE = NodeKindTest.NAMESPACE;
    public static final ItemType PI = NodeKindTest.PROCESSING_INSTRUCTION;
    public static final ItemType TEXT = NodeKindTest.TEXT;
    public static final SequenceType EMPTY_SEQUENCE = SequenceType.EMPTY_SEQUENCE;
    public static final SequenceType SINGLE_ITEM = SequenceType.SINGLE_ITEM;
    public static final SequenceType SINGLE_BASE64 = Types.make(16384, BASE64);
    public static final SequenceType SINGLE_BOOLEAN = SequenceType.SINGLE_BOOLEAN;
    public static final SequenceType SINGLE_BYTE = SequenceType.SINGLE_BYTE;
    public static final SequenceType SINGLE_DATE = Types.make(16384, DATE);
    public static final SequenceType SINGLE_DATETIME = Types.make(16384, DATETIME);
    public static final SequenceType SINGLE_DECIMAL = Types.make(16384, DECIMAL);
    public static final SequenceType SINGLE_DOUBLE = SequenceType.SINGLE_DOUBLE;
    public static final SequenceType SINGLE_FLOAT = SequenceType.SINGLE_FLOAT;
    public static final SequenceType SINGLE_INT = Types.make(16384, INT);
    public static final SequenceType SINGLE_INTEGER = SequenceType.SINGLE_INTEGER;
    public static final SequenceType SINGLE_LONG = Types.make(16384, LONG);
    public static final SequenceType SINGLE_SHORT = SequenceType.SINGLE_SHORT;
    public static final SequenceType SINGLE_STRING = SequenceType.SINGLE_STRING;
    public static final SequenceType SINGLE_URI = Types.make(16384, URI);
    public static final SequenceType SINGLE_NODE = SequenceType.SINGLE_NODE;
    public static final SequenceType SINGLE_ATTRIBUTE = Types.make(16384, ATTRIBUTE);
    public static final SequenceType SINGLE_COMMENT = Types.make(16384, COMMENT);
    public static final SequenceType SINGLE_DOCUMENT = Types.make(16384, DOCUMENT);
    public static final SequenceType SINGLE_ELEMENT = Types.make(16384, ELEMENT);
    public static final SequenceType SINGLE_NAMESPACE = Types.make(16384, NAMESPACE);
    public static final SequenceType SINGLE_PI = Types.make(16384, PI);
    public static final SequenceType SINGLE_TEXT = Types.make(16384, TEXT);
    public static final SequenceType OPTIONAL_ITEM = SequenceType.OPTIONAL_ITEM;
    public static final SequenceType OPTIONAL_BASE64 = Types.make(24576, BASE64);
    public static final SequenceType OPTIONAL_BOOLEAN = SequenceType.OPTIONAL_BOOLEAN;
    public static final SequenceType OPTIONAL_BYTE = SequenceType.OPTIONAL_BYTE;
    public static final SequenceType OPTIONAL_DATE = Types.make(24576, DATE);
    public static final SequenceType OPTIONAL_DATETIME = SequenceType.OPTIONAL_DATE_TIME;
    public static final SequenceType OPTIONAL_DECIMAL = SequenceType.OPTIONAL_DECIMAL;
    public static final SequenceType OPTIONAL_DOUBLE = SequenceType.OPTIONAL_DOUBLE;
    public static final SequenceType OPTIONAL_FLOAT = SequenceType.OPTIONAL_FLOAT;
    public static final SequenceType OPTIONAL_INT = Types.make(24576, INT);
    public static final SequenceType OPTIONAL_INTEGER = SequenceType.OPTIONAL_INTEGER;
    public static final SequenceType OPTIONAL_LONG = Types.make(24576, LONG);
    public static final SequenceType OPTIONAL_SHORT = SequenceType.OPTIONAL_SHORT;
    public static final SequenceType OPTIONAL_STRING = SequenceType.OPTIONAL_STRING;
    public static final SequenceType OPTIONAL_URI = SequenceType.OPTIONAL_ANY_URI;
    public static final SequenceType OPTIONAL_NODE = SequenceType.OPTIONAL_NODE;
    public static final SequenceType OPTIONAL_ATTRIBUTE = Types.make(24576, ATTRIBUTE);
    public static final SequenceType OPTIONAL_COMMENT = Types.make(24576, COMMENT);
    public static final SequenceType OPTIONAL_DOCUMENT = SequenceType.OPTIONAL_DOCUMENT_NODE;
    public static final SequenceType OPTIONAL_ELEMENT = Types.make(24576, ELEMENT);
    public static final SequenceType OPTIONAL_NAMESPACE = Types.make(24576, NAMESPACE);
    public static final SequenceType OPTIONAL_PI = Types.make(24576, PI);
    public static final SequenceType OPTIONAL_TEXT = Types.make(24576, TEXT);
    public static final SequenceType ANY_ITEM = SequenceType.ANY_SEQUENCE;
    public static final SequenceType ANY_BASE64 = Types.make(57344, BASE64);
    public static final SequenceType ANY_BOOLEAN = Types.make(57344, BOOLEAN);
    public static final SequenceType ANY_BYTE = Types.make(57344, BYTE);
    public static final SequenceType ANY_DATE = Types.make(57344, DATE);
    public static final SequenceType ANY_DATETIME = Types.make(57344, DATETIME);
    public static final SequenceType ANY_DECIMAL = Types.make(57344, DECIMAL);
    public static final SequenceType ANY_DOUBLE = Types.make(57344, DOUBLE);
    public static final SequenceType ANY_FLOAT = Types.make(57344, FLOAT);
    public static final SequenceType ANY_INT = Types.make(57344, INT);
    public static final SequenceType ANY_INTEGER = Types.make(57344, INTEGER);
    public static final SequenceType ANY_LONG = Types.make(57344, LONG);
    public static final SequenceType ANY_SHORT = Types.make(57344, SHORT);
    public static final SequenceType ANY_STRING = SequenceType.STRING_SEQUENCE;
    public static final SequenceType ANY_URI = Types.make(57344, URI);
    public static final SequenceType ANY_NODE = SequenceType.NODE_SEQUENCE;
    public static final SequenceType ANY_ATTRIBUTE = Types.make(16384, ATTRIBUTE);
    public static final SequenceType ANY_COMMENT = Types.make(16384, COMMENT);
    public static final SequenceType ANY_DOCUMENT = Types.make(16384, DOCUMENT);
    public static final SequenceType ANY_ELEMENT = Types.make(16384, ELEMENT);
    public static final SequenceType ANY_NAMESPACE = Types.make(16384, NAMESPACE);
    public static final SequenceType ANY_PI = Types.make(16384, PI);
    public static final SequenceType ANY_TEXT = Types.make(16384, TEXT);
    public static final SequenceType SEVERAL_ITEM = SequenceType.NON_EMPTY_SEQUENCE;
    public static final SequenceType SEVERAL_BASE64 = Types.make(49152, BASE64);
    public static final SequenceType SEVERAL_BOOLEAN = Types.make(49152, BOOLEAN);
    public static final SequenceType SEVERAL_BYTE = Types.make(49152, BYTE);
    public static final SequenceType SEVERAL_DATE = Types.make(49152, DATE);
    public static final SequenceType SEVERAL_DATETIME = Types.make(49152, DATETIME);
    public static final SequenceType SEVERAL_DECIMAL = Types.make(49152, DECIMAL);
    public static final SequenceType SEVERAL_DOUBLE = Types.make(49152, DOUBLE);
    public static final SequenceType SEVERAL_FLOAT = Types.make(49152, FLOAT);
    public static final SequenceType SEVERAL_INT = Types.make(49152, INT);
    public static final SequenceType SEVERAL_INTEGER = Types.make(49152, INTEGER);
    public static final SequenceType SEVERAL_LONG = Types.make(49152, LONG);
    public static final SequenceType SEVERAL_SHORT = Types.make(49152, SHORT);
    public static final SequenceType SEVERAL_STRING = Types.make(49152, STRING);
    public static final SequenceType SEVERAL_URI = Types.make(49152, URI);
    public static final SequenceType SEVERAL_NODE = Types.make(49152, NODE);
    public static final SequenceType SEVERAL_ATTRIBUTE = Types.make(49152, ATTRIBUTE);
    public static final SequenceType SEVERAL_COMMENT = Types.make(49152, COMMENT);
    public static final SequenceType SEVERAL_DOCUMENT = Types.make(49152, DOCUMENT);
    public static final SequenceType SEVERAL_ELEMENT = Types.make(49152, ELEMENT);
    public static final SequenceType SEVERAL_NAMESPACE = Types.make(49152, NAMESPACE);
    public static final SequenceType SEVERAL_PI = Types.make(49152, PI);
    public static final SequenceType SEVERAL_TEXT = Types.make(49152, TEXT);
    private final Library myLib;

    public Types(Library lib) {
        this.myLib = lib;
    }

    public static SequenceType[] types(SequenceType ... args) {
        return args;
    }

    public StructuredQName qname(String local) {
        String uri = this.myLib.getNamespace();
        String prefix = this.myLib.getPrefix();
        return new StructuredQName(prefix, uri, local);
    }

    public SequenceType singleElement(String local, Processor saxon) {
        return this.element(16384, local, saxon);
    }

    public SequenceType optionalElement(String local, Processor saxon) {
        return this.element(24576, local, saxon);
    }

    public SequenceType anyElement(String local, Processor saxon) {
        return this.element(57344, local, saxon);
    }

    public SequenceType severalElement(String local, Processor saxon) {
        return this.element(49152, local, saxon);
    }

    private SequenceType element(int occurrence, String local, Processor saxon) {
        boolean kind = true;
        String uri = this.myLib.getNamespace();
        NamePool pool = saxon.getUnderlyingConfiguration().getNamePool();
        NameTest itype = new NameTest(1, uri, local, pool);
        return SequenceType.makeSequenceType((ItemType)itype, (int)occurrence);
    }

    private static SequenceType make(int occurrence, ItemType type) {
        return SequenceType.makeSequenceType((ItemType)type, (int)occurrence);
    }
}

