/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.saxon;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;

public class Version {
    private static final String VER_PROP = "/org/expath/tools/saxon/version.properties";
    private static Version INSTANCE = null;
    private String myVersion;
    private String myRevision;

    protected Version() {
        InputStream rsrc = Version.class.getResourceAsStream(VER_PROP);
        if (rsrc == null) {
            throw new IllegalStateException("Version properties file does not exist: /org/expath/tools/saxon/version.properties");
        }
        Properties props = new Properties();
        try {
            props.load(rsrc);
            rsrc.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error reading the version properties: /org/expath/tools/saxon/version.properties", ex);
        }
        this.myVersion = props.getProperty("org.expath.tools.saxon.version");
        this.myRevision = props.getProperty("org.expath.tools.saxon.revision");
    }

    public static void main(String[] args) {
        Version.instance().display(System.out);
    }

    public void display(PrintStream out) {
        out.println("EXPath Tools for Saxon.");
        out.println("Version: " + this.getVersion() + " (revision #" + this.getRevision() + ")");
    }

    public static synchronized Version instance() {
        if (INSTANCE == null) {
            INSTANCE = new Version();
        }
        return INSTANCE;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getRevision() {
        return this.myRevision;
    }
}

