/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.temporal.TemporalQueries;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsLeapYear<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final TemporalAdapter<T> adapter;

    public IsLeapYear(TemporalAdapter<T> adapter) {
        this.adapter = adapter;
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        if (this.adapter.asTemporal(actual).query(TemporalQueries.localDate()).isLeapYear()) {
            return true;
        }
        mismatchDesc.appendText("a leap year");
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a leap year");
    }
}

