/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.DayOfWeek;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsDayOfWeek<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final Set<DayOfWeek> daysOfWeeks = new HashSet<DayOfWeek>();
    private final String description;
    private final TemporalAdapter<T> accessor;

    public IsDayOfWeek(List<DayOfWeek> daysOfWeek, TemporalAdapter<T> accessor) {
        this.daysOfWeeks.addAll(daysOfWeek);
        this.description = daysOfWeek.stream().map(d -> d.name().toLowerCase()).collect(Collectors.joining(", "));
        this.accessor = accessor;
    }

    public IsDayOfWeek(DayOfWeek dayOfWeek, TemporalAdapter<T> accessor) {
        this(Arrays.asList(dayOfWeek), accessor);
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        DayOfWeek actualValue = DayOfWeek.of(this.accessor.asTemporal(actual).get(ChronoField.DAY_OF_WEEK));
        if (this.daysOfWeeks.contains(actualValue)) {
            return true;
        }
        mismatchDesc.appendText("the date is on " + actualValue.name().toLowerCase());
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("the date is on on the days of the week " + this.description);
    }
}

