/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyScriptAddRepoPlugin
extends BaseComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger(GroovyScriptAddRepoPlugin.class);
    private final InitParams params;
    private final RepositoryService repositoryService;

    public GroovyScriptAddRepoPlugin(InitParams params, RepositoryService repoService) {
        this.params = params;
        this.repositoryService = repoService;
    }

    public Collection<URL> getRepositories() {
        if (this.params == null) {
            return Collections.emptyList();
        }
        final HashSet<URL> repos = new HashSet<URL>();
        Iterator iterator = this.params.getPropertiesParamIterator();
        while (iterator.hasNext()) {
            PropertiesParam p = (PropertiesParam)iterator.next();
            final String repository = this.getWorkingRepositoryName(p);
            final String workspace = p.getProperty("workspace");
            final String path = p.getProperty("path");
            try {
                SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws MalformedURLException {
                        repos.add(new UnifiedNodeReference(repository, workspace, path).getURL());
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                LOG.error((Object)("Failed add groovy script repository. " + e.getCause().getMessage()));
            }
        }
        return repos;
    }

    private String getWorkingRepositoryName(PropertiesParam props) {
        if (props.getProperty("repository") == null) {
            try {
                return this.repositoryService.getCurrentRepository().getConfiguration().getName();
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Can not get current repository and repository name was not configured", e);
            }
        }
        return props.getProperty("repository");
    }
}

