/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.util.Calendar;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.RepositoryRestoreExeption;
import org.exoplatform.services.jcr.ext.backup.server.WorkspaceRestoreExeption;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JobWorkspaceRestore
extends Thread {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ext.JobWorkspaceRestore");
    public static final int RESTORE_STARTED = 1;
    public static final int RESTORE_SUCCESSFUL = 2;
    public static final int RESTORE_FAIL = 3;
    public static final int RESTORE_INITIALIZED = 4;
    private int stateRestore;
    protected final String repositoryName;
    protected final WorkspaceEntry wEntry;
    protected final RepositoryService repositoryService;
    private final BackupManager backupManager;
    private Throwable restoreException = null;
    private Calendar startTime;
    private Calendar endTime;
    protected final File backupChainLogFile;

    public JobWorkspaceRestore(RepositoryService repositoryService, BackupManager backupManager, String repositoryName, File logFile, WorkspaceEntry wEntry) {
        super("JobWorkspaceRestore " + repositoryName + "_" + wEntry.getName());
        this.repositoryService = repositoryService;
        this.backupManager = backupManager;
        this.repositoryName = repositoryName;
        this.backupChainLogFile = logFile;
        this.wEntry = wEntry;
        this.stateRestore = 4;
    }

    public void run() {
        try {
            this.restore();
        }
        catch (Throwable t) {
            LOG.error((Object)"The restore was fail", t);
        }
    }

    protected final void restore() throws Throwable {
        try {
            this.stateRestore = 1;
            this.startTime = Calendar.getInstance();
            this.restoreWorkspace();
            this.stateRestore = 2;
            this.endTime = Calendar.getInstance();
        }
        catch (Throwable t) {
            this.stateRestore = 3;
            this.restoreException = t;
            throw new RepositoryRestoreExeption(t.getMessage(), t);
        }
    }

    protected void restoreWorkspace() throws Throwable {
        boolean restored = true;
        RepositoryImpl repository = (RepositoryImpl)this.repositoryService.getRepository(this.repositoryName);
        try {
            RepositoryEntry reEntry = repository.getConfiguration();
            this.backupManager.restore(new BackupChainLog(this.backupChainLogFile), reEntry.getName(), this.wEntry, false);
        }
        catch (InvalidItemStateException e) {
            restored = false;
            throw new WorkspaceRestoreExeption("Workspace '/" + this.repositoryName + "/" + this.wEntry.getName() + "' can not be restored! There was database error!", e);
        }
        catch (Throwable t) {
            restored = false;
            throw new WorkspaceRestoreExeption("Workspace '/" + this.repositoryName + "/" + this.wEntry.getName() + "' can not be restored!", t);
        }
        finally {
            if (!restored) {
                try {
                    this.removeWorkspace((ManageableRepository)repository, this.wEntry.getName());
                }
                catch (Throwable thr) {
                    throw new WorkspaceRestoreExeption("Workspace '/" + this.repositoryName + "/" + this.wEntry.getName() + "' can not be restored!", thr);
                }
            }
        }
    }

    protected void removeWorkspace(ManageableRepository mr, String workspaceName) throws RepositoryException {
        boolean isExists = false;
        for (String wsName : mr.getWorkspaceNames()) {
            if (!workspaceName.equals(wsName)) continue;
            isExists = true;
            break;
        }
        if (isExists) {
            if (!mr.canRemoveWorkspace(workspaceName)) {
                WorkspaceContainerFacade wc = mr.getWorkspaceContainer(workspaceName);
                SessionRegistry sessionRegistry = (SessionRegistry)wc.getComponent(SessionRegistry.class);
                sessionRegistry.closeSessions(workspaceName);
            }
            mr.removeWorkspace(workspaceName);
        }
    }

    public Throwable getRestoreException() {
        return this.restoreException;
    }

    public int getStateRestore() {
        return this.stateRestore;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public BackupChainLog getBackupChainLog() throws BackupOperationException {
        return new BackupChainLog(this.backupChainLogFile);
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getWorkspaceName() {
        return this.wEntry.getName();
    }

    public WorkspaceEntry getWorkspaceEntry() {
        return this.wEntry;
    }
}

