/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.ext.backup.impl.AbstractBackupJob;
import org.exoplatform.services.jcr.impl.backup.SuspendException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractIncrementalBackupJob
extends AbstractBackupJob
implements ItemsPersistenceListener {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.IncrementalBackupJob");
    protected final List<ItemStateChangesLog> suspendBuffer;
    protected AtomicInteger workingThreads = new AtomicInteger();
    protected CountDownLatch latcher = null;

    public AbstractIncrementalBackupJob() {
        this.suspendBuffer = Collections.synchronizedList(new ArrayList());
        this.id = 1;
        this.notifyListeners();
    }

    public final int getType() {
        return 2;
    }

    public void onSaveItems(ItemStateChangesLog chlog) {
        if (this.state == 4) {
            return;
        }
        if (this.state == 1) {
            this.suspendBuffer.add(chlog);
        } else if (this.state == 2) {
            try {
                if (this.latcher != null && this.latcher.getCount() != 0L) {
                    this.latcher.await();
                }
                this.workingThreads.incrementAndGet();
                this.save(chlog);
                this.workingThreads.decrementAndGet();
            }
            catch (IOException e) {
                log.error((Object)"Incremental backup: Can't save log ", (Throwable)e);
                this.notifyError("Incremental backup: Can't save log ", e);
            }
            catch (InterruptedException e) {
                log.error((Object)"Incremental backup: Can't save log ", (Throwable)e);
                this.notifyError("Incremental backup: Can't save log ", e);
            }
        }
    }

    public final void run() {
        this.repository.addItemPersistenceListener(this.workspaceName, (ItemsPersistenceListener)this);
        this.state = 2;
        this.notifyListeners();
    }

    public final void suspend() {
        this.state = 1;
        ++this.id;
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final URL resume() {
        try {
            block8: {
                try {
                    while (this.workingThreads.get() != 0) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            throw new SuspendException((Throwable)e);
                        }
                    }
                    this.url = this.createStorage();
                    this.latcher = new CountDownLatch(1);
                    this.state = 2;
                    for (ItemStateChangesLog log : this.suspendBuffer) {
                        this.save(log);
                    }
                    if (this.config.getIncrementalJobNumber() == 0 || this.id != this.config.getIncrementalJobNumber() + 1) break block8;
                    this.state = 4;
                }
                catch (Throwable e) {
                    log.error((Object)"Incremental backup: resume failed ", e);
                    this.notifyError("Incremental backup: resume failed ", e);
                    Object var4_6 = null;
                    this.suspendBuffer.clear();
                    this.latcher.countDown();
                }
            }
            Object var4_5 = null;
            this.suspendBuffer.clear();
            this.latcher.countDown();
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.suspendBuffer.clear();
            this.latcher.countDown();
            throw throwable;
        }
        this.notifyListeners();
        return this.url;
    }

    protected abstract void save(ItemStateChangesLog var1) throws IOException;
}

