/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet.impl;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestUrl {
    public static final Logger LOG = LoggerFactory.getLogger(RequestUrl.class);

    private RequestUrl() {
    }

    public static String getRelativeUrl(HttpServletRequest request, boolean servlet) {
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String relativeUrl = requestURI;
        if (contextPath != null && relativeUrl.startsWith(contextPath)) {
            relativeUrl = relativeUrl.substring(contextPath.length());
        }
        if (servlet && servletPath != null && relativeUrl.startsWith(servletPath)) {
            relativeUrl = relativeUrl.substring(servletPath.length());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("requestURI: {}, contextPath: {}, servletPath: {}, relativeUrl: {}, ", new Object[]{requestURI, contextPath, servletPath, relativeUrl});
        }
        return relativeUrl;
    }
}

