/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet.impl;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.cookie.Cookie;
import org.esigate.http.IncomingRequest;
import org.esigate.http.cookie.CookieUtil;

public class ResponseSender {
    public void sendResponse(HttpResponse httpResponse, IncomingRequest httpRequest, HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        this.sendHeaders(httpResponse, httpRequest, response);
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            httpEntity.writeTo((OutputStream)response.getOutputStream());
        } else {
            response.sendError(httpResponse.getStatusLine().getStatusCode(), httpResponse.getStatusLine().getReasonPhrase());
        }
    }

    void sendHeaders(HttpResponse httpResponse, IncomingRequest httpRequest, HttpServletResponse response) {
        response.setStatus(httpResponse.getStatusLine().getStatusCode());
        for (Header header : httpResponse.getAllHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            response.addHeader(name, value);
        }
        Cookie[] newCookies = httpRequest.getNewCookies();
        for (int i = 0; i < newCookies.length; ++i) {
            response.addHeader("Set-Cookie", CookieUtil.encodeCookie((Cookie)newCookies[i]));
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            Header contentEncoding;
            Header contentType;
            long contentLength = httpEntity.getContentLength();
            if (contentLength > -1L && contentLength < Integer.MAX_VALUE) {
                response.setContentLength((int)contentLength);
            }
            if ((contentType = httpEntity.getContentType()) != null) {
                response.setContentType(contentType.getValue());
            }
            if ((contentEncoding = httpEntity.getContentEncoding()) != null) {
                response.setHeader(contentEncoding.getName(), contentEncoding.getValue());
            }
        }
    }
}

