/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet.impl;

import javax.servlet.http.HttpServletRequest;
import org.esigate.impl.UriMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestUrl {
    private static final Logger LOG = LoggerFactory.getLogger(RequestUrl.class);

    private RequestUrl() {
    }

    public static String getRelativeUrl(HttpServletRequest request, UriMapping mapping, boolean servlet) {
        String mappingPath;
        String relativeUrl = request.getRequestURI();
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String string = mappingPath = mapping == null ? null : mapping.getPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug("relativeUrl: {}, contextPath: {}, servletPath: {}, mappingPath: {}", new Object[]{relativeUrl, contextPath, servletPath, mappingPath});
        }
        if (contextPath != null && relativeUrl.startsWith(contextPath)) {
            relativeUrl = relativeUrl.substring(contextPath.length());
        }
        if (servlet && servletPath != null && relativeUrl.startsWith(servletPath)) {
            relativeUrl = relativeUrl.substring(servletPath.length());
        }
        if (mappingPath != null && relativeUrl.startsWith(mappingPath)) {
            relativeUrl = relativeUrl.substring(mappingPath.length());
        }
        return relativeUrl;
    }
}

