/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet.impl;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.tuple.Pair;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.impl.UriMapping;
import org.esigate.servlet.impl.RequestUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DriverSelector {
    private static final Logger LOG = LoggerFactory.getLogger(DriverSelector.class);

    public Pair<Driver, UriMapping> selectProvider(HttpServletRequest request, boolean servlet) throws HttpErrorPage {
        String host = request.getHeader("Host");
        String scheme = request.getScheme();
        String relUrl = RequestUrl.getRelativeUrl(request, null, servlet);
        Pair result = DriverFactory.getInstanceFor((String)scheme, (String)host, (String)relUrl);
        LOG.debug("Selected {} for scheme:{} host:{} relUrl:{}", new Object[]{result, scheme, host, relUrl});
        return result;
    }
}

