/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.server;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jetty9.InstrumentedConnectionFactory;
import com.codahale.metrics.jetty9.InstrumentedHandler;
import com.codahale.metrics.jetty9.InstrumentedQueuedThreadPool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.webapp.WebAppContext;
import org.esigate.server.ControlHandler;
import org.esigate.server.metrics.InstrumentedServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EsigateServer {
    private static final Logger LOG = LoggerFactory.getLogger(EsigateServer.class);
    private static String contextPath;
    private static int controlPort;
    private static String extraClasspath;
    private static long idleTimeout;
    private static int maxThreads;
    private static int minThreads;
    private static int outputBufferSize;
    private static int port;
    private static final int PROPERTY_DEFAULT_CONTROL_PORT = 8081;
    private static final int PROPERTY_DEFAULT_HTTP_PORT = 8080;
    private static final String PROPERTY_PREFIX = "server.";
    private static Server srv;

    private EsigateServer() {
    }

    private static int getProperty(String prefix, String name, int defaultValue) {
        int result = defaultValue;
        try {
            result = Integer.parseInt(System.getProperty(prefix + name));
        }
        catch (NumberFormatException e) {
            LOG.warn("Value for " + prefix + name + " must be an integer. Using default " + defaultValue);
        }
        return result;
    }

    private static String getProperty(String prefix, String name, String defaultValue) {
        return System.getProperty(prefix + name, defaultValue);
    }

    public static void init() {
        String configFile = null;
        Properties serverProperties = new Properties();
        try {
            configFile = System.getProperty("server.config", "server.properties");
            LOG.info("Loading server configuration from " + configFile);
            try (FileInputStream is = new FileInputStream(configFile);){
                serverProperties.load(is);
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn(configFile + " not found.");
        }
        catch (IOException e) {
            LOG.error("Unexpected error reading " + configFile);
        }
        EsigateServer.init(serverProperties);
    }

    public static void init(Properties configuration) {
        for (Object prop : configuration.keySet()) {
            String serverPropertyName = (String)prop;
            System.setProperty(PROPERTY_PREFIX + serverPropertyName, configuration.getProperty(serverPropertyName));
        }
        LOG.info("Using configuration provided using '-D' parameter and/or default values");
        port = EsigateServer.getProperty(PROPERTY_PREFIX, "port", 8080);
        controlPort = EsigateServer.getProperty(PROPERTY_PREFIX, "controlPort", 8081);
        contextPath = EsigateServer.getProperty(PROPERTY_PREFIX, "contextPath", "/");
        extraClasspath = EsigateServer.getProperty(PROPERTY_PREFIX, "extraClasspath", null);
        maxThreads = EsigateServer.getProperty(PROPERTY_PREFIX, "maxThreads", 500);
        minThreads = EsigateServer.getProperty(PROPERTY_PREFIX, "minThreads", 40);
        outputBufferSize = EsigateServer.getProperty(PROPERTY_PREFIX, "outputBufferSize", 8192);
        idleTimeout = EsigateServer.getProperty(PROPERTY_PREFIX, "idleTimeout", 30000);
    }

    public static int getControlPort() {
        return controlPort;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            EsigateServer.usage();
            return;
        }
        switch (args[0]) {
            case "start": {
                EsigateServer.init();
                EsigateServer.start();
                break;
            }
            case "stop": {
                EsigateServer.stop();
                break;
            }
            default: {
                EsigateServer.usage();
            }
        }
    }

    private static File resetTempDirectory(String currentDir) throws IOException {
        File workDir = new File(currentDir, "work");
        if (workDir.exists()) {
            try {
                FileUtils.cleanDirectory(workDir);
            }
            catch (IllegalArgumentException e) {
                LOG.info("Info: issue while deleting work directory, it was already deleted. Not a problem.");
            }
        }
        return workDir;
    }

    public static void start() throws Exception {
        MetricRegistry registry = new MetricRegistry();
        InstrumentedQueuedThreadPool threadPool = new InstrumentedQueuedThreadPool(registry);
        threadPool.setName("esigate");
        threadPool.setMaxThreads(maxThreads);
        threadPool.setMinThreads(minThreads);
        srv = new Server(threadPool);
        srv.setStopAtShutdown(true);
        srv.setStopTimeout(5000L);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setOutputBufferSize(outputBufferSize);
        httpConfig.setSendServerVersion(false);
        Timer processTime = registry.timer("processTime");
        try (InstrumentedServerConnector connector = new InstrumentedServerConnector("main", port, srv, registry, new InstrumentedConnectionFactory(new HttpConnectionFactory(httpConfig), processTime));
             ServerConnector controlConnector = new ServerConnector(srv);){
            connector.setIdleTimeout(idleTimeout);
            connector.setSoLingerTime(-1);
            connector.setName("main");
            connector.setAcceptQueueSize(200);
            controlConnector.setHost("127.0.0.1");
            controlConnector.setPort(controlPort);
            controlConnector.setName("control");
            srv.setConnectors(new Connector[]{connector, controlConnector});
            ProtectionDomain protectionDomain = EsigateServer.class.getProtectionDomain();
            String warFile = protectionDomain.getCodeSource().getLocation().toExternalForm();
            String currentDir = new File(protectionDomain.getCodeSource().getLocation().getPath()).getParent();
            File workDir = EsigateServer.resetTempDirectory(currentDir);
            WebAppContext context = new WebAppContext(warFile, contextPath);
            context.setServer(srv);
            context.setTempDirectory(workDir);
            if (extraClasspath != null) {
                context.setExtraClasspath(extraClasspath);
            }
            HandlerList handlers = new HandlerList();
            handlers.addHandler(new ControlHandler(registry));
            InstrumentedHandler ih = new InstrumentedHandler(registry);
            ih.setName("main");
            ih.setHandler(context);
            handlers.addHandler(ih);
            srv.setHandler(handlers);
            srv.start();
            srv.join();
        }
    }

    public static boolean isStarted() {
        if (srv == null) {
            return false;
        }
        return srv.isStarted();
    }

    public static void stop() {
        ControlHandler.shutdown(controlPort);
    }

    private static void usage() {
        StringBuffer usageText = new StringBuffer();
        usageText.append("Usage: java -Desigate.config=esigate.properties -jar esigate-server.jar [start|stop]\n\t");
        usageText.append("start    Start the server (default)\n\t");
        usageText.append("stop     Stop the server gracefully\n\t");
        System.out.println(usageText.toString());
        System.exit(-1);
    }

    static {
        idleTimeout = 0L;
        maxThreads = 0;
        minThreads = 0;
        outputBufferSize = 0;
        srv = null;
    }
}

