/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.IllegalSelectorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.EncodingHttpWriter;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpWriter;
import org.eclipse.jetty.server.Iso88591HttpWriter;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.Utf8HttpWriter;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Response
implements HttpServletResponse {
    private static final Logger LOG = Log.getLogger(Response.class);
    private static final String __COOKIE_DELIM = "\",;\\ \t";
    private static final String __01Jan1970_COOKIE = DateGenerator.formatCookieDate(0L).trim();
    private static final ThreadLocal<StringBuilder> __cookieBuilder = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder(128);
        }
    };
    public static final String SET_INCLUDE_HEADER_PREFIX = "org.eclipse.jetty.server.include.";
    public static final String HTTP_ONLY_COMMENT = "__HTTP_ONLY__";
    private final HttpChannel<?> _channel;
    private final HttpFields _fields = new HttpFields();
    private final AtomicInteger _include = new AtomicInteger();
    private HttpOutput _out;
    private int _status = 0;
    private String _reason;
    private Locale _locale;
    private MimeTypes.Type _mimeType;
    private String _characterEncoding;
    private boolean _explicitEncoding;
    private String _contentType;
    private OutputType _outputType = OutputType.NONE;
    private ResponseWriter _writer;
    private long _contentLength = -1L;

    public static Response getResponse(HttpServletResponse response) {
        if (response instanceof Response) {
            return (Response)response;
        }
        return HttpChannel.getCurrentHttpChannel().getResponse();
    }

    public Response(HttpChannel<?> channel, HttpOutput out) {
        this._channel = channel;
        this._out = out;
    }

    protected HttpChannel<?> getHttpChannel() {
        return this._channel;
    }

    protected void recycle() {
        this._status = 0;
        this._reason = null;
        this._locale = null;
        this._mimeType = null;
        this._characterEncoding = null;
        this._contentType = null;
        this._outputType = OutputType.NONE;
        this._contentLength = -1L;
        this._out.reset();
        this._fields.clear();
        this._explicitEncoding = false;
    }

    public void setHeaders(HttpContent httpContent) {
        long lml;
        String lm;
        Response response = this._channel.getResponse();
        String contentType = httpContent.getContentType();
        if (contentType != null && !response.getHttpFields().containsKey(HttpHeader.CONTENT_TYPE.asString())) {
            this.setContentType(contentType);
        }
        if (httpContent.getContentLength() > 0L) {
            this.setLongContentLength(httpContent.getContentLength());
        }
        if ((lm = httpContent.getLastModified()) != null) {
            response.getHttpFields().put(HttpHeader.LAST_MODIFIED, lm);
        } else if (httpContent.getResource() != null && (lml = httpContent.getResource().lastModified()) != -1L) {
            response.getHttpFields().putDateField(HttpHeader.LAST_MODIFIED, lml);
        }
        String etag = httpContent.getETag();
        if (etag != null) {
            response.getHttpFields().put(HttpHeader.ETAG, etag);
        }
    }

    public HttpOutput getHttpOutput() {
        return this._out;
    }

    public void setHttpOutput(HttpOutput out) {
        this._out = out;
    }

    public boolean isIncluding() {
        return this._include.get() > 0;
    }

    public void include() {
        this._include.incrementAndGet();
    }

    public void included() {
        this._include.decrementAndGet();
        if (this._outputType == OutputType.WRITER) {
            this._writer.reopen();
        }
        this._out.reopen();
    }

    public void addCookie(HttpCookie cookie) {
        this.addSetCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getMaxAge(), cookie.getComment(), cookie.isSecure(), cookie.isHttpOnly(), cookie.getVersion());
    }

    @Override
    public void addCookie(Cookie cookie) {
        int i;
        String comment = cookie.getComment();
        boolean httpOnly = false;
        if (comment != null && (i = comment.indexOf(HTTP_ONLY_COMMENT)) >= 0) {
            httpOnly = true;
            if ((comment = comment.replace(HTTP_ONLY_COMMENT, "").trim()).length() == 0) {
                comment = null;
            }
        }
        this.addSetCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getMaxAge(), comment, cookie.getSecure(), httpOnly || cookie.isHttpOnly(), cookie.getVersion());
    }

    public void addSetCookie(String name, String value, String domain, String path, long maxAge, String comment, boolean isSecure, boolean isHttpOnly, int version) {
        boolean quote_path;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuilder buf = __cookieBuilder.get();
        buf.setLength(0);
        boolean quote_name = Response.isQuoteNeededForCookie(name);
        Response.quoteOnlyOrAppend(buf, name, quote_name);
        buf.append('=');
        String name_equals = buf.toString();
        boolean quote_value = Response.isQuoteNeededForCookie(value);
        Response.quoteOnlyOrAppend(buf, value, quote_value);
        boolean has_domain = domain != null && domain.length() > 0;
        boolean quote_domain = has_domain && Response.isQuoteNeededForCookie(domain);
        boolean has_path = path != null && path.length() > 0;
        boolean bl = quote_path = has_path && Response.isQuoteNeededForCookie(path);
        if (version == 0 && (comment != null || quote_name || quote_value || quote_domain || quote_path || QuotedStringTokenizer.isQuoted(name) || QuotedStringTokenizer.isQuoted(value) || QuotedStringTokenizer.isQuoted(path) || QuotedStringTokenizer.isQuoted(domain))) {
            version = 1;
        }
        if (version == 1) {
            buf.append(";Version=1");
        } else if (version > 1) {
            buf.append(";Version=").append(version);
        }
        if (has_path) {
            buf.append(";Path=");
            Response.quoteOnlyOrAppend(buf, path, quote_path);
        }
        if (has_domain) {
            buf.append(";Domain=");
            Response.quoteOnlyOrAppend(buf, domain, quote_domain);
        }
        if (maxAge >= 0L) {
            buf.append(";Expires=");
            if (maxAge == 0L) {
                buf.append(__01Jan1970_COOKIE);
            } else {
                DateGenerator.formatCookieDate(buf, System.currentTimeMillis() + 1000L * maxAge);
            }
            if (version >= 1) {
                buf.append(";Max-Age=");
                buf.append(maxAge);
            }
        }
        if (isSecure) {
            buf.append(";Secure");
        }
        if (isHttpOnly) {
            buf.append(";HttpOnly");
        }
        if (comment != null) {
            buf.append(";Comment=");
            Response.quoteOnlyOrAppend(buf, comment, Response.isQuoteNeededForCookie(comment));
        }
        Iterator<HttpField> i = this._fields.iterator();
        while (i.hasNext()) {
            String val;
            HttpField field = i.next();
            if (field.getHeader() != HttpHeader.SET_COOKIE || (val = field.getValue()) == null || !val.startsWith(name_equals) || (has_domain || val.contains("Domain")) && (!has_domain || !val.contains(domain)) || (has_path || val.contains("Path")) && (!has_path || !val.contains(path))) continue;
            i.remove();
        }
        this._fields.add(HttpHeader.SET_COOKIE.toString(), buf.toString());
        this._fields.put(HttpHeader.EXPIRES.toString(), DateGenerator.__01Jan1970);
    }

    private static boolean isQuoteNeededForCookie(String s) {
        if (s == null || s.length() == 0) {
            return true;
        }
        if (QuotedStringTokenizer.isQuoted(s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (__COOKIE_DELIM.indexOf(c) >= 0) {
                return true;
            }
            if (c >= ' ' && c < '\u007f') continue;
            throw new IllegalArgumentException("Illegal character in cookie value");
        }
        return false;
    }

    private static void quoteOnlyOrAppend(StringBuilder buf, String s, boolean quote) {
        if (quote) {
            QuotedStringTokenizer.quoteOnly(buf, s);
        } else {
            buf.append(s);
        }
    }

    @Override
    public boolean containsHeader(String name) {
        return this._fields.containsKey(name);
    }

    @Override
    public String encodeURL(String url) {
        int prefix;
        String sessionURLPrefix;
        Request request = this._channel.getRequest();
        SessionManager sessionManager = request.getSessionManager();
        if (sessionManager == null) {
            return url;
        }
        HttpURI uri = null;
        if (sessionManager.isCheckingRemoteSessionIdEncoding() && URIUtil.hasScheme(url)) {
            uri = new HttpURI(url);
            String path = uri.getPath();
            path = path == null ? "" : path;
            int port = uri.getPort();
            if (port < 0) {
                int n = port = HttpScheme.HTTPS.asString().equalsIgnoreCase(uri.getScheme()) ? 443 : 80;
            }
            if (!request.getServerName().equalsIgnoreCase(uri.getHost()) || request.getServerPort() != port || !path.startsWith(request.getContextPath())) {
                return url;
            }
        }
        if ((sessionURLPrefix = sessionManager.getSessionIdPathParameterNamePrefix()) == null) {
            return url;
        }
        if (url == null) {
            return null;
        }
        if (sessionManager.isUsingCookies() && request.isRequestedSessionIdFromCookie() || !sessionManager.isUsingURLs()) {
            int prefix2 = url.indexOf(sessionURLPrefix);
            if (prefix2 != -1) {
                int suffix = url.indexOf("?", prefix2);
                if (suffix < 0) {
                    suffix = url.indexOf("#", prefix2);
                }
                if (suffix <= prefix2) {
                    return url.substring(0, prefix2);
                }
                return url.substring(0, prefix2) + url.substring(suffix);
            }
            return url;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return url;
        }
        if (!sessionManager.isValid(session)) {
            return url;
        }
        String id = sessionManager.getNodeId(session);
        if (uri == null) {
            uri = new HttpURI(url);
        }
        if ((prefix = url.indexOf(sessionURLPrefix)) != -1) {
            int suffix = url.indexOf("?", prefix);
            if (suffix < 0) {
                suffix = url.indexOf("#", prefix);
            }
            if (suffix <= prefix) {
                return url.substring(0, prefix + sessionURLPrefix.length()) + id;
            }
            return url.substring(0, prefix + sessionURLPrefix.length()) + id + url.substring(suffix);
        }
        int suffix = url.indexOf(63);
        if (suffix < 0) {
            suffix = url.indexOf(35);
        }
        if (suffix < 0) {
            return url + ((HttpScheme.HTTPS.is(uri.getScheme()) || HttpScheme.HTTP.is(uri.getScheme())) && uri.getPath() == null ? "/" : "") + sessionURLPrefix + id;
        }
        return url.substring(0, suffix) + ((HttpScheme.HTTPS.is(uri.getScheme()) || HttpScheme.HTTP.is(uri.getScheme())) && uri.getPath() == null ? "/" : "") + sessionURLPrefix + id + url.substring(suffix);
    }

    @Override
    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    @Override
    @Deprecated
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Override
    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    @Override
    public void sendError(int sc) throws IOException {
        if (sc == 102) {
            this.sendProcessing();
        } else {
            this.sendError(sc, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendError(int code, String message) throws IOException {
        block35: {
            block36: {
                if (this.isIncluding()) {
                    return;
                }
                if (this.isCommitted()) {
                    LOG.warn("Committed before " + code + " " + message, new Object[0]);
                }
                this.resetBuffer();
                this._characterEncoding = null;
                this.setHeader(HttpHeader.EXPIRES, null);
                this.setHeader(HttpHeader.LAST_MODIFIED, null);
                this.setHeader(HttpHeader.CACHE_CONTROL, null);
                this.setHeader(HttpHeader.CONTENT_TYPE, null);
                this.setHeader(HttpHeader.CONTENT_LENGTH, null);
                this._outputType = OutputType.NONE;
                this.setStatus(code);
                this._reason = message;
                Request request = this._channel.getRequest();
                Throwable cause = (Throwable)request.getAttribute("javax.servlet.error.exception");
                if (message == null) {
                    String string = message = cause == null ? HttpStatus.getMessage(code) : cause.toString();
                }
                if (code == 204 || code == 304 || code == 206 || code < 200) break block36;
                ErrorHandler error_handler = null;
                ContextHandler.Context context = request.getContext();
                if (context != null) {
                    error_handler = context.getContextHandler().getErrorHandler();
                }
                if (error_handler == null) {
                    error_handler = this._channel.getServer().getBean(ErrorHandler.class);
                }
                if (error_handler != null) {
                    request.setAttribute("javax.servlet.error.status_code", new Integer(code));
                    request.setAttribute("javax.servlet.error.message", message);
                    request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
                    request.setAttribute("javax.servlet.error.servlet_name", request.getServletName());
                    error_handler.handle(null, this._channel.getRequest(), this._channel.getRequest(), this);
                    break block35;
                } else {
                    this.setHeader(HttpHeader.CACHE_CONTROL, "must-revalidate,no-cache,no-store");
                    this.setContentType(MimeTypes.Type.TEXT_HTML_8859_1.toString());
                    try (ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(2048);){
                        String uri;
                        if (message != null) {
                            message = StringUtil.replace(message, "&", "&amp;");
                            message = StringUtil.replace(message, "<", "&lt;");
                            message = StringUtil.replace(message, ">", "&gt;");
                        }
                        if ((uri = request.getRequestURI()) != null) {
                            uri = StringUtil.replace(uri, "&", "&amp;");
                            uri = StringUtil.replace(uri, "<", "&lt;");
                            uri = StringUtil.replace(uri, ">", "&gt;");
                        }
                        writer.write("<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=ISO-8859-1\"/>\n");
                        writer.write("<title>Error ");
                        writer.write(Integer.toString(code));
                        writer.write(' ');
                        if (message == null) {
                            writer.write(message);
                        }
                        writer.write("</title>\n</head>\n<body>\n<h2>HTTP ERROR: ");
                        writer.write(Integer.toString(code));
                        writer.write("</h2>\n<p>Problem accessing ");
                        writer.write(uri);
                        writer.write(". Reason:\n<pre>    ");
                        writer.write(message);
                        writer.write("</pre>");
                        writer.write("</p>\n<hr /><i><small>Powered by Jetty://</small></i>");
                        writer.write("\n</body>\n</html>\n");
                        writer.flush();
                        this.setContentLength(writer.size());
                        try (ServletOutputStream outputStream = this.getOutputStream();){
                            writer.writeTo(outputStream);
                            writer.destroy();
                            break block35;
                        }
                    }
                }
            }
            if (code != 206) {
                this._channel.getRequest().getHttpFields().remove(HttpHeader.CONTENT_TYPE);
                this._channel.getRequest().getHttpFields().remove(HttpHeader.CONTENT_LENGTH);
                this._characterEncoding = null;
                this._mimeType = null;
            }
        }
        this.closeOutput();
    }

    public void sendProcessing() throws IOException {
        if (this._channel.isExpecting102Processing() && !this.isCommitted()) {
            this._channel.sendResponse(HttpGenerator.PROGRESS_102_INFO, null, true);
        }
    }

    public void sendRedirect(int code, String location) throws IOException {
        if (code < 300 || code >= 400) {
            throw new IllegalArgumentException("Not a 3xx redirect code");
        }
        if (this.isIncluding()) {
            return;
        }
        if (location == null) {
            throw new IllegalArgumentException();
        }
        if (!URIUtil.hasScheme(location)) {
            StringBuilder buf = this._channel.getRequest().getRootURL();
            if (location.startsWith("//")) {
                buf.delete(0, buf.length());
                buf.append(this._channel.getRequest().getScheme());
                buf.append(":");
                buf.append(location);
            } else if (location.startsWith("/")) {
                buf.append(location);
            } else {
                String path = this._channel.getRequest().getRequestURI();
                String parent = path.endsWith("/") ? path : URIUtil.parentPath(path);
                location = URIUtil.addPaths(parent, location);
                if (location == null) {
                    throw new IllegalStateException("path cannot be above root");
                }
                if (!location.startsWith("/")) {
                    buf.append('/');
                }
                buf.append(location);
            }
            location = buf.toString();
            HttpURI uri = new HttpURI(location);
            String path = uri.getDecodedPath();
            String canonical = URIUtil.canonicalPath(path);
            if (canonical == null) {
                throw new IllegalArgumentException();
            }
            if (!canonical.equals(path)) {
                String fragment;
                String query;
                buf = this._channel.getRequest().getRootURL();
                buf.append(URIUtil.encodePath(canonical));
                String param = uri.getParam();
                if (param != null) {
                    buf.append(';');
                    buf.append(param);
                }
                if ((query = uri.getQuery()) != null) {
                    buf.append('?');
                    buf.append(query);
                }
                if ((fragment = uri.getFragment()) != null) {
                    buf.append('#');
                    buf.append(fragment);
                }
                location = buf.toString();
            }
        }
        this.resetBuffer();
        this.setHeader(HttpHeader.LOCATION, location);
        this.setStatus(code);
        this.closeOutput();
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.sendRedirect(302, location);
    }

    @Override
    public void setDateHeader(String name, long date) {
        if (!this.isIncluding()) {
            this._fields.putDateField(name, date);
        }
    }

    @Override
    public void addDateHeader(String name, long date) {
        if (!this.isIncluding()) {
            this._fields.addDateField(name, date);
        }
    }

    public void setHeader(HttpHeader name, String value) {
        if (HttpHeader.CONTENT_TYPE == name) {
            this.setContentType(value);
        } else {
            if (this.isIncluding()) {
                return;
            }
            this._fields.put(name, value);
            if (HttpHeader.CONTENT_LENGTH == name) {
                this._contentLength = value == null ? -1L : Long.parseLong(value);
            }
        }
    }

    @Override
    public void setHeader(String name, String value) {
        if (HttpHeader.CONTENT_TYPE.is(name)) {
            this.setContentType(value);
        } else {
            if (this.isIncluding()) {
                if (name.startsWith(SET_INCLUDE_HEADER_PREFIX)) {
                    name = name.substring(SET_INCLUDE_HEADER_PREFIX.length());
                } else {
                    return;
                }
            }
            this._fields.put(name, value);
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                this._contentLength = value == null ? -1L : Long.parseLong(value);
            }
        }
    }

    @Override
    public Collection<String> getHeaderNames() {
        HttpFields fields = this._fields;
        return fields.getFieldNamesCollection();
    }

    @Override
    public String getHeader(String name) {
        return this._fields.getStringField(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        HttpFields fields = this._fields;
        List<String> i = fields.getValuesList(name);
        if (i == null) {
            return Collections.emptyList();
        }
        return i;
    }

    @Override
    public void addHeader(String name, String value) {
        if (this.isIncluding()) {
            if (name.startsWith(SET_INCLUDE_HEADER_PREFIX)) {
                name = name.substring(SET_INCLUDE_HEADER_PREFIX.length());
            } else {
                return;
            }
        }
        if (HttpHeader.CONTENT_TYPE.is(name)) {
            this.setContentType(value);
            return;
        }
        if (HttpHeader.CONTENT_LENGTH.is(name)) {
            this.setHeader(name, value);
            return;
        }
        this._fields.add(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        if (!this.isIncluding()) {
            this._fields.putLongField(name, (long)value);
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                this._contentLength = value;
            }
        }
    }

    @Override
    public void addIntHeader(String name, int value) {
        if (!this.isIncluding()) {
            this._fields.add(name, Integer.toString(value));
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                this._contentLength = value;
            }
        }
    }

    @Override
    public void setStatus(int sc) {
        if (sc <= 0) {
            throw new IllegalArgumentException();
        }
        if (!this.isIncluding()) {
            this._status = sc;
            this._reason = null;
        }
    }

    @Override
    @Deprecated
    public void setStatus(int sc, String sm) {
        this.setStatusWithReason(sc, sm);
    }

    public void setStatusWithReason(int sc, String sm) {
        if (sc <= 0) {
            throw new IllegalArgumentException();
        }
        if (!this.isIncluding()) {
            this._status = sc;
            this._reason = sm;
        }
    }

    @Override
    public String getCharacterEncoding() {
        if (this._characterEncoding == null) {
            this._characterEncoding = "ISO-8859-1";
        }
        return this._characterEncoding;
    }

    @Override
    public String getContentType() {
        return this._contentType;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this._outputType == OutputType.WRITER) {
            throw new IllegalStateException("WRITER");
        }
        this._outputType = OutputType.STREAM;
        return this._out;
    }

    public boolean isWriting() {
        return this._outputType == OutputType.WRITER;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this._outputType == OutputType.STREAM) {
            throw new IllegalStateException("STREAM");
        }
        if (this._outputType == OutputType.NONE) {
            String encoding = this._characterEncoding;
            if (encoding == null) {
                if (this._mimeType != null && this._mimeType.isCharsetAssumed()) {
                    encoding = this._mimeType.getCharset().toString();
                } else {
                    encoding = MimeTypes.inferCharsetFromContentType(this._contentType);
                    if (encoding == null) {
                        encoding = "ISO-8859-1";
                    }
                    this.setCharacterEncoding(encoding, false);
                }
            }
            if (this._writer != null && this._writer.isFor(encoding)) {
                this._writer.reopen();
            } else {
                this._writer = "ISO-8859-1".equalsIgnoreCase(encoding) ? new ResponseWriter(new Iso88591HttpWriter(this._out), encoding) : ("UTF-8".equalsIgnoreCase(encoding) ? new ResponseWriter(new Utf8HttpWriter(this._out), encoding) : new ResponseWriter(new EncodingHttpWriter(this._out, encoding), encoding));
            }
            this._outputType = OutputType.WRITER;
        }
        return this._writer;
    }

    @Override
    public void setContentLength(int len) {
        if (this.isCommitted() || this.isIncluding()) {
            return;
        }
        this._contentLength = len;
        if (this._contentLength > 0L) {
            long written = this._out.getWritten();
            if (written > (long)len) {
                throw new IllegalArgumentException("setContentLength(" + len + ") when already written " + written);
            }
            this._fields.putLongField(HttpHeader.CONTENT_LENGTH, (long)len);
            if (this.isAllContentWritten(written)) {
                try {
                    this.closeOutput();
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        } else if (this._contentLength == 0L) {
            long written = this._out.getWritten();
            if (written > 0L) {
                throw new IllegalArgumentException("setContentLength(0) when already written " + written);
            }
            this._fields.put(HttpHeader.CONTENT_LENGTH, "0");
        } else {
            this._fields.remove(HttpHeader.CONTENT_LENGTH);
        }
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public boolean isAllContentWritten(long written) {
        return this._contentLength >= 0L && written >= this._contentLength;
    }

    public void closeOutput() throws IOException {
        switch (this._outputType) {
            case WRITER: {
                this._writer.close();
                if (this._out.isClosed()) break;
                this._out.close();
                break;
            }
            case STREAM: {
                this.getOutputStream().close();
                break;
            }
            default: {
                this._out.close();
            }
        }
    }

    public long getLongContentLength() {
        return this._contentLength;
    }

    public void setLongContentLength(long len) {
        if (this.isCommitted() || this.isIncluding()) {
            return;
        }
        this._contentLength = len;
        this._fields.putLongField(HttpHeader.CONTENT_LENGTH.toString(), len);
    }

    @Override
    public void setContentLengthLong(long length) {
        this.setLongContentLength(length);
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        this.setCharacterEncoding(encoding, true);
    }

    private void setCharacterEncoding(String encoding, boolean explicit) {
        if (this.isIncluding() || this.isWriting()) {
            return;
        }
        if (this._outputType == OutputType.NONE && !this.isCommitted()) {
            if (encoding == null) {
                this._explicitEncoding = false;
                if (this._characterEncoding != null) {
                    this._characterEncoding = null;
                    if (this._mimeType != null) {
                        this._mimeType = this._mimeType.getBaseType();
                        this._contentType = this._mimeType.asString();
                        this._fields.put(this._mimeType.getContentTypeField());
                    } else if (this._contentType != null) {
                        this._contentType = MimeTypes.getContentTypeWithoutCharset(this._contentType);
                        this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
                    }
                }
            } else {
                this._explicitEncoding = explicit;
                String string = this._characterEncoding = HttpGenerator.__STRICT ? encoding : StringUtil.normalizeCharset(encoding);
                if (this._mimeType != null) {
                    this._contentType = this._mimeType.getBaseType().asString() + "; charset=" + this._characterEncoding;
                    this._mimeType = MimeTypes.CACHE.get(this._contentType);
                    if (this._mimeType == null || HttpGenerator.__STRICT) {
                        this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
                    } else {
                        this._fields.put(this._mimeType.getContentTypeField());
                    }
                } else if (this._contentType != null) {
                    this._contentType = MimeTypes.getContentTypeWithoutCharset(this._contentType) + "; charset=" + this._characterEncoding;
                    this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
                }
            }
        }
    }

    @Override
    public void setContentType(String contentType) {
        if (this.isCommitted() || this.isIncluding()) {
            return;
        }
        if (contentType == null) {
            if (this.isWriting() && this._characterEncoding != null) {
                throw new IllegalSelectorException();
            }
            if (this._locale == null) {
                this._characterEncoding = null;
            }
            this._mimeType = null;
            this._contentType = null;
            this._fields.remove(HttpHeader.CONTENT_TYPE);
        } else {
            this._contentType = contentType;
            this._mimeType = MimeTypes.CACHE.get(contentType);
            String charset = this._mimeType != null && this._mimeType.getCharset() != null && !this._mimeType.isCharsetAssumed() ? this._mimeType.getCharset().toString() : MimeTypes.getCharsetFromContentType(contentType);
            if (charset == null) {
                if (this._characterEncoding != null) {
                    this._contentType = contentType + "; charset=" + this._characterEncoding;
                    this._mimeType = null;
                }
            } else if (this.isWriting() && !charset.equals(this._characterEncoding)) {
                this._mimeType = null;
                this._contentType = MimeTypes.getContentTypeWithoutCharset(this._contentType);
                if (this._characterEncoding != null) {
                    this._contentType = this._contentType + "; charset=" + this._characterEncoding;
                }
            } else {
                this._characterEncoding = charset;
                this._explicitEncoding = true;
            }
            if (HttpGenerator.__STRICT || this._mimeType == null) {
                this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
            } else {
                this._contentType = this._mimeType.asString();
                this._fields.put(this._mimeType.getContentTypeField());
            }
        }
    }

    @Override
    public void setBufferSize(int size) {
        if (this.isCommitted() || this.getContentCount() > 0L) {
            throw new IllegalStateException("Committed or content written");
        }
        this._out.setBufferSize(size);
    }

    @Override
    public int getBufferSize() {
        return this._out.getBufferSize();
    }

    @Override
    public void flushBuffer() throws IOException {
        if (!this._out.isClosed()) {
            this._out.flush();
        }
    }

    @Override
    public void reset() {
        this.resetForForward();
        this._status = 200;
        this._reason = null;
        this._contentLength = -1L;
        this._fields.clear();
        String connection = this._channel.getRequest().getHttpFields().getStringField(HttpHeader.CONNECTION);
        if (connection != null) {
            String[] values = connection.split(",");
            block5: for (int i = 0; values != null && i < values.length; ++i) {
                HttpHeaderValue cb = HttpHeaderValue.CACHE.get(values[0].trim());
                if (cb == null) continue;
                switch (cb) {
                    case CLOSE: {
                        this._fields.put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.toString());
                        continue block5;
                    }
                    case KEEP_ALIVE: {
                        if (!HttpVersion.HTTP_1_0.is(this._channel.getRequest().getProtocol())) continue block5;
                        this._fields.put(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.toString());
                        continue block5;
                    }
                    case TE: {
                        this._fields.put(HttpHeader.CONNECTION, HttpHeaderValue.TE.toString());
                        continue block5;
                    }
                }
            }
        }
    }

    public void reset(boolean preserveCookies) {
        if (!preserveCookies) {
            this.reset();
        } else {
            ArrayList<String> cookieValues = new ArrayList<String>(5);
            Enumeration<String> vals = this._fields.getValues(HttpHeader.SET_COOKIE.asString());
            while (vals.hasMoreElements()) {
                cookieValues.add(vals.nextElement());
            }
            this.reset();
            for (String v : cookieValues) {
                this._fields.add(HttpHeader.SET_COOKIE, v);
            }
        }
    }

    public void resetForForward() {
        this.resetBuffer();
        this._outputType = OutputType.NONE;
    }

    @Override
    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        switch (this._outputType) {
            case WRITER: 
            case STREAM: {
                this._out.reset();
                break;
            }
        }
        this._out.resetBuffer();
    }

    protected HttpGenerator.ResponseInfo newResponseInfo() {
        if (this._status == 0) {
            this._status = 200;
        }
        return new HttpGenerator.ResponseInfo(this._channel.getRequest().getHttpVersion(), this._fields, this.getLongContentLength(), this.getStatus(), this.getReason(), this._channel.getRequest().isHead());
    }

    @Override
    public boolean isCommitted() {
        return this._channel.isCommitted();
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null || this.isCommitted() || this.isIncluding()) {
            return;
        }
        this._locale = locale;
        this._fields.put(HttpHeader.CONTENT_LANGUAGE, locale.toString().replace('_', '-'));
        if (this._outputType != OutputType.NONE) {
            return;
        }
        if (this._channel.getRequest().getContext() == null) {
            return;
        }
        String charset = this._channel.getRequest().getContext().getContextHandler().getLocaleEncoding(locale);
        if (charset != null && charset.length() > 0 && !this._explicitEncoding) {
            this.setCharacterEncoding(charset, false);
        }
    }

    @Override
    public Locale getLocale() {
        if (this._locale == null) {
            return Locale.getDefault();
        }
        return this._locale;
    }

    @Override
    public int getStatus() {
        return this._status;
    }

    public String getReason() {
        return this._reason;
    }

    public HttpFields getHttpFields() {
        return this._fields;
    }

    public long getContentCount() {
        return this._out.getWritten();
    }

    public String toString() {
        return String.format("%s %d %s%n%s", new Object[]{this._channel.getRequest().getHttpVersion(), this._status, this._reason == null ? "" : this._reason, this._fields});
    }

    private static class ResponseWriter
    extends PrintWriter {
        private final String _encoding;
        private final HttpWriter _httpWriter;

        public ResponseWriter(HttpWriter httpWriter, String encoding) {
            super(httpWriter);
            this._httpWriter = httpWriter;
            this._encoding = encoding;
        }

        public boolean isFor(String encoding) {
            return this._encoding.equalsIgnoreCase(encoding);
        }

        protected void reopen() {
            super.clearError();
            this.out = this._httpWriter;
        }
    }

    public static enum OutputType {
        NONE,
        STREAM,
        WRITER;

    }
}

