/*
 * Decompiled with CFR 0.152.
 */
package bekkopen.jetty;

import bekkopen.jetty.ShutdownHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.ProtectionDomain;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;

public class Main {
    private final int port;
    private final String contextPath;
    private final String workPath;
    private final String secret;

    public static void main(String[] args) throws Exception {
        Main sc = new Main();
        if (args.length != 1) {
            sc.start();
        } else if ("status".equals(args[0])) {
            sc.status();
        } else if ("offline".equals(args[0])) {
            sc.offline();
        } else if ("online".equals(args[0])) {
            sc.online();
        } else if ("stop".equals(args[0])) {
            sc.stop();
        } else if ("start".equals(args[0])) {
            sc.start();
        } else {
            sc.usage();
        }
    }

    public Main() {
        try {
            String configFile = System.getProperty("config", "jetty.properties");
            System.getProperties().load(new FileInputStream(configFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.port = Integer.parseInt(System.getProperty("jetty.port", "8080"));
        this.contextPath = System.getProperty("jetty.contextPath", "/");
        this.workPath = System.getProperty("jetty.workDir", null);
        this.secret = System.getProperty("jetty.secret", "eb27fb2e61ed603363461b3b4e37e0a0");
    }

    private void start() {
        try {
            Server srv = new Server();
            srv.setStopAtShutdown(true);
            srv.setGracefulShutdown(5000);
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setMaxThreads(100);
            srv.setThreadPool(threadPool);
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(this.port);
            connector.setMaxIdleTime(30000);
            srv.setConnectors(new Connector[]{connector});
            ProtectionDomain protectionDomain = Main.class.getProtectionDomain();
            String warFile = protectionDomain.getCodeSource().getLocation().toExternalForm();
            String currentDir = new File(protectionDomain.getCodeSource().getLocation().getPath()).getParent();
            WebAppContext context = new WebAppContext(warFile, this.contextPath);
            context.setServer(srv);
            this.resetTempDirectory(context, currentDir);
            HandlerList handlers = new HandlerList();
            handlers.addHandler(context);
            handlers.addHandler(new ShutdownHandler(srv, context, this.secret));
            srv.setHandler(handlers);
            srv.start();
            srv.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stop() {
        System.out.println(ShutdownHandler.shutdown(this.port, this.secret));
    }

    private void status() {
    }

    private void online() {
    }

    private void offline() {
    }

    private void usage() {
        System.out.println("Usage: java -jar <file.jar> [start|stop|status|enable|disable]\n\tstart    Start the server (default)\n\tstop     Stop the server gracefully\n\tstatus   Check the current server status\n\tonline   Sign in to BigIP load balancer\n\toffline  Sign out from BigIP load balancer\n");
        System.exit(-1);
    }

    private void resetTempDirectory(WebAppContext context, String currentDir) throws IOException {
        File workDir = this.workPath != null ? new File(this.workPath) : new File(currentDir, "work");
        FileUtils.deleteDirectory(workDir);
        context.setTempDirectory(workDir);
    }
}

