/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.tags;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.impl.DriverRequest;
import org.esigate.parser.Parser;
import org.esigate.tags.BlockElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockRenderer
implements Renderer,
Appendable {
    private static final Logger LOG = LoggerFactory.getLogger(BlockRenderer.class);
    private static final Pattern PATTERN = Pattern.compile("<!--\\$[^>]*\\$-->");
    private final Parser parser = new Parser(PATTERN, BlockElement.TYPE);
    private final String page;
    private final String name;
    private boolean write;
    private Writer out;

    public void setWrite(boolean write) {
        this.write = write;
    }

    public String getName() {
        return this.name;
    }

    public BlockRenderer(String name, String page) {
        this.name = name;
        this.page = page;
        if (name == null) {
            this.write = true;
        }
    }

    @Override
    public void render(DriverRequest httpRequest, String content, Writer pOut) throws IOException, HttpErrorPage {
        LOG.debug("Rendering block " + this.name + " in page " + this.page);
        this.out = pOut;
        if (content == null) {
            return;
        }
        if (this.name == null) {
            this.out.write(content);
        } else {
            this.parser.parse(content, this);
        }
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        if (this.write) {
            this.out.append(csq);
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        if (this.write) {
            this.out.append(c);
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        if (this.write) {
            this.out.append(csq, start, end);
        }
        return this;
    }
}

