/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.parser.future;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.esigate.HttpErrorPage;
import org.esigate.parser.future.FutureAppendable;
import org.esigate.parser.future.FutureAppendableAdapter;

public class StringBuilderFutureAppendable
implements FutureAppendable,
Future<CharSequence> {
    private final StringBuilder builder;
    private final FutureAppendableAdapter futureBuilder;

    public StringBuilderFutureAppendable() {
        this(1024);
    }

    private StringBuilderFutureAppendable(int capacity) {
        this.builder = new StringBuilder(capacity);
        this.futureBuilder = new FutureAppendableAdapter(this.builder);
    }

    @Override
    public FutureAppendable enqueueAppend(Future<CharSequence> csq) {
        return this.futureBuilder.enqueueAppend(csq);
    }

    @Override
    public FutureAppendable performAppends() throws IOException, HttpErrorPage {
        return this.futureBuilder.performAppends();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.futureBuilder.hasPending();
    }

    @Override
    public CharSequence get() throws ExecutionException {
        try {
            this.futureBuilder.performAppends();
        }
        catch (IOException | HttpErrorPage e) {
            throw new ExecutionException(e);
        }
        return this.builder.toString();
    }

    @Override
    public CharSequence get(long timeout, TimeUnit unit) throws ExecutionException {
        try {
            this.futureBuilder.performAppends();
        }
        catch (IOException | HttpErrorPage e) {
            throw new ExecutionException(e);
        }
        return this.builder.toString();
    }

    @Override
    public boolean hasPending() {
        return this.futureBuilder.hasPending();
    }

    @Override
    public FutureAppendable performAppends(int timeout, TimeUnit unit) throws IOException, HttpErrorPage, TimeoutException {
        return this.futureBuilder.performAppends(timeout, unit);
    }
}

