/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.impl;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;
import org.esigate.api.RedirectStrategy2;
import org.esigate.http.OutgoingRequest;
import org.esigate.http.ResourceUtils;
import org.esigate.impl.DriverRequest;
import org.esigate.util.UriUtils;

public class FragmentRedirectStrategy
implements RedirectStrategy2 {
    private final DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        return this.redirectStrategy.isRedirected(request, response, context);
    }

    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        URI uri = this.getLocationURI(request, response, context);
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("HEAD")) {
            return new HttpHead(uri);
        }
        if (method.equalsIgnoreCase("GET")) {
            return new HttpGet(uri);
        }
        int status = response.getStatusLine().getStatusCode();
        if (status == 307) {
            return RequestBuilder.copy((HttpRequest)request).setUri(uri).build();
        }
        return new HttpGet(uri);
    }

    @Override
    public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        DriverRequest driverRequest;
        URI uri = this.redirectStrategy.getLocationURI(request, response, context);
        String resultingPageUrl = uri.toString();
        if (StringUtils.startsWith((CharSequence)resultingPageUrl, (CharSequence)(driverRequest = ((OutgoingRequest)request).getOriginalRequest()).getVisibleBaseUrl())) {
            resultingPageUrl = "/" + StringUtils.stripStart((String)StringUtils.replace((String)resultingPageUrl, (String)driverRequest.getVisibleBaseUrl(), (String)""), (String)"/");
        }
        resultingPageUrl = ResourceUtils.getHttpUrlWithQueryString(resultingPageUrl, driverRequest, false);
        return UriUtils.createURI(ResourceUtils.getHttpUrlWithQueryString(resultingPageUrl, driverRequest, false));
    }
}

