/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.http.HttpHost;
import org.apache.http.conn.DnsResolver;
import org.apache.http.impl.client.HttpClientBuilder;
import org.esigate.Driver;
import org.esigate.Parameters;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.HttpClientBuilderEvent;
import org.esigate.extension.Extension;
import org.esigate.extension.http.CustomizableDNSResolver;
import org.esigate.util.Parameter;
import org.esigate.util.ParameterCollection;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNS
implements Extension,
IEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(DNS.class);
    public static final Parameter<Collection<String>> REMOTE_IP = new ParameterCollection("remoteIP");
    private DnsResolver dnsResolver;

    public DnsResolver getDnsResolver() {
        return this.dnsResolver;
    }

    @Override
    public void init(Driver driver, Properties properties) {
        Collection<String> ips = REMOTE_IP.getValue(properties);
        if (ips.isEmpty()) {
            LOG.error("Missing configuration properties for driver {}. Property {}", (Object)driver.getConfiguration().getInstanceName(), (Object)REMOTE_IP.getName());
        } else {
            String[] remoteURLS = Parameters.REMOTE_URL_BASE.getValue(properties);
            ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>();
            CustomizableDNSResolver customizableDNSResolver = new CustomizableDNSResolver();
            this.dnsResolver = customizableDNSResolver;
            for (String ip : ips) {
                try {
                    inetAddresses.add(InetAddress.getByName(ip));
                }
                catch (UnknownHostException e) {
                    LOG.error("Unable to resolve InetAddress [{}]", (Object)ip, (Object)e);
                }
            }
            for (String remoteURL : remoteURLS) {
                HttpHost host = UriUtils.extractHost(remoteURL);
                customizableDNSResolver.add(host.getHostName(), inetAddresses.toArray(new InetAddress[0]));
            }
            driver.getEventManager().register(EventManager.EVENT_HTTP_BUILDER_INITIALIZATION, this);
        }
    }

    @Override
    public boolean event(EventDefinition id, Event event) {
        HttpClientBuilderEvent httpClientBuilderEvent = (HttpClientBuilderEvent)event;
        HttpClientBuilder httpClientBuilder = httpClientBuilderEvent.getHttpClientBuilder();
        httpClientBuilder.setDnsResolver(this.dnsResolver);
        return false;
    }
}

