/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizableDNSResolver
extends SystemDefaultDnsResolver {
    private static final Logger LOG = LoggerFactory.getLogger(CustomizableDNSResolver.class);
    private final Map<String, InetAddress[]> dnsMap = new HashMap<String, InetAddress[]>();

    public void add(String host, InetAddress ... ips) {
        this.dnsMap.put(host, ips);
    }

    public InetAddress[] resolve(String host) throws UnknownHostException {
        Object[] resolvedAddresses = this.dnsMap.get(host);
        if (LOG.isInfoEnabled()) {
            LOG.info("Resolving {} to {}", (Object)host, (Object)Arrays.deepToString(resolvedAddresses));
        }
        if (resolvedAddresses == null) {
            resolvedAddresses = super.resolve(host);
        }
        return resolvedAddresses;
    }
}

