/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.esigate.ConfigurationException;
import org.esigate.Driver;
import org.esigate.extension.Extension;
import org.esigate.util.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionFactory.class);

    private ExtensionFactory() {
    }

    public static <T extends Extension> T getExtension(Properties properties, Parameter<String> parameter, Driver d) {
        Extension result;
        String className = parameter.getValue(properties);
        if (className == null) {
            return null;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating  extension " + className);
            }
            result = (Extension)Class.forName(className).newInstance();
            result.init(d, properties);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException(e);
        }
        return (T)result;
    }

    public static <T extends Extension> List<T> getExtensions(Properties properties, Parameter<Collection<String>> parameter, Driver d) {
        Collection<String> className = parameter.getValue(properties);
        ArrayList<Extension> finalResult = new ArrayList<Extension>();
        for (String cName : className) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating  extension " + className);
                }
                Extension result = (Extension)Class.forName(cName).newInstance();
                result.init(d, properties);
                finalResult.add(result);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new ConfigurationException(e);
            }
        }
        return finalResult;
    }
}

