/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.io.IOException;
import java.util.Properties;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.cache.HttpCacheUpdateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheStorage
implements HttpCacheStorage {
    private static final Logger LOG = LoggerFactory.getLogger(CacheStorage.class);
    private HttpCacheStorage impl;

    public abstract void init(Properties var1);

    public void putEntry(String key, HttpCacheEntry entry) throws IOException {
        LOG.debug("putEntry({},{})", (Object)key, (Object)entry);
        this.impl.putEntry(key, entry);
    }

    public HttpCacheEntry getEntry(String key) throws IOException {
        LOG.debug("getEntry({})", (Object)key);
        return this.impl.getEntry(key);
    }

    public void removeEntry(String key) throws IOException {
        LOG.debug("removeEntry({})", (Object)key);
        this.impl.removeEntry(key);
    }

    public void updateEntry(String key, HttpCacheUpdateCallback callback) throws IOException, HttpCacheUpdateException {
        LOG.debug("updateEntry({},{})", (Object)key, (Object)callback);
        this.impl.updateEntry(key, callback);
    }

    public void setImpl(HttpCacheStorage impl) {
        this.impl = impl;
    }
}

