/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.authentication;

import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.FragmentEvent;
import org.esigate.events.impl.ProxyEvent;
import org.esigate.extension.Extension;
import org.esigate.http.IncomingRequest;
import org.esigate.http.OutgoingRequest;

public abstract class GenericAuthentificationHandler
implements IEventListener,
Extension {
    private Driver driver;

    public abstract boolean beforeProxy(HttpRequest var1);

    public abstract void preRequest(OutgoingRequest var1, IncomingRequest var2);

    public abstract boolean needsNewRequest(HttpResponse var1, OutgoingRequest var2, IncomingRequest var3);

    @Override
    public final void init(Driver d, Properties properties) {
        this.driver = d;
        this.driver.getEventManager().register(EventManager.EVENT_PROXY_PRE, this);
        this.driver.getEventManager().register(EventManager.EVENT_FRAGMENT_PRE, this);
        this.driver.getEventManager().register(EventManager.EVENT_FRAGMENT_POST, this);
        this.init(properties);
    }

    public abstract void init(Properties var1);

    @Override
    public boolean event(EventDefinition id, Event event) {
        if (EventManager.EVENT_FRAGMENT_PRE.equals(id)) {
            FragmentEvent e = (FragmentEvent)event;
            this.preRequest(e.getHttpRequest(), e.getOriginalRequest());
        } else if (EventManager.EVENT_FRAGMENT_POST.equals(id)) {
            FragmentEvent e = (FragmentEvent)event;
            while (this.needsNewRequest((HttpResponse)e.getHttpResponse(), e.getHttpRequest(), e.getOriginalRequest())) {
                EntityUtils.consumeQuietly((HttpEntity)e.getHttpResponse().getEntity());
                this.preRequest(e.getHttpRequest(), e.getOriginalRequest());
                try {
                    e.setHttpResponse(this.driver.getRequestExecutor().execute(e.getHttpRequest()));
                }
                catch (HttpErrorPage e1) {
                    e.setHttpResponse(e1.getHttpResponse());
                }
            }
        } else if (EventManager.EVENT_PROXY_PRE.equals(id)) {
            ProxyEvent e;
            e.setExit(!this.beforeProxy((HttpRequest)(e = (ProxyEvent)event).getOriginalRequest()));
        }
        return true;
    }

    public Driver getDriver() {
        return this.driver;
    }
}

