/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.aggregator;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.aggregator.AggregateRenderer;
import org.esigate.aggregator.ElementAttributes;
import org.esigate.aggregator.ElementAttributesFactory;
import org.esigate.http.HttpResponseUtils;
import org.esigate.parser.Adapter;
import org.esigate.parser.Element;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContext;
import org.esigate.tags.BlockRenderer;

class IncludeBlockElement
implements Element {
    public static final ElementType TYPE = new ElementType(){

        @Override
        public boolean isStartTag(String tag) {
            return tag.startsWith("<!--$includeblock$");
        }

        @Override
        public boolean isEndTag(String tag) {
            return tag.startsWith("<!--$endincludeblock$");
        }

        @Override
        public Element newInstance() {
            return new IncludeBlockElement();
        }

        @Override
        public boolean isSelfClosing(String tag) {
            return false;
        }
    };

    IncludeBlockElement() {
    }

    @Override
    public boolean onError(Exception e, ParserContext ctx) {
        return false;
    }

    @Override
    public void onTagEnd(String tag, ParserContext ctx) {
    }

    @Override
    public boolean onTagStart(String tag, ParserContext ctx) throws IOException, HttpErrorPage {
        ElementAttributes tagAttributes = ElementAttributesFactory.createElementAttributes(tag);
        Driver driver = tagAttributes.getDriver();
        String page = tagAttributes.getPage();
        String name = tagAttributes.getName();
        CloseableHttpResponse response = driver.render(page, ctx.getHttpRequest().getOriginalRequest(), new BlockRenderer(name, page), new AggregateRenderer());
        new Adapter(ctx.getCurrent()).append(HttpResponseUtils.toString(response));
        return true;
    }

    @Override
    public void characters(CharSequence csq, int start, int end) {
    }
}

