/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.esigate.ConfigurationException;
import org.esigate.Parameters;
import org.esigate.api.BaseUrlRetrieveStrategy;
import org.esigate.impl.UriMapping;
import org.esigate.url.IpHashBaseUrlRetrieveStrategy;
import org.esigate.url.RoundRobinBaseUrlRetrieveStrategy;
import org.esigate.url.SingleBaseUrlRetrieveStrategy;
import org.esigate.url.StickySessionBaseUrlRetrieveStrategy;

public class DriverConfiguration {
    private final String instanceName;
    private final String uriEncoding;
    private final String visibleBaseURL;
    private final Properties properties;
    private final boolean preserveHost;
    private final BaseUrlRetrieveStrategy baseUrlRetrieveStrategy;
    private final List<UriMapping> uriMappings;
    private boolean stripMappingPath;

    public DriverConfiguration(String instanceName, Properties props) {
        this.instanceName = instanceName;
        this.baseUrlRetrieveStrategy = this.getBaseUrlRetrieveSession(props);
        this.uriEncoding = Parameters.URI_ENCODING.getValue(props);
        this.preserveHost = Parameters.PRESERVE_HOST.getValue(props);
        this.visibleBaseURL = Parameters.VISIBLE_URL_BASE.getValue(props);
        this.stripMappingPath = Parameters.STRIP_MAPPING_PATH.getValue(props);
        this.uriMappings = DriverConfiguration.parseMappings(props);
        this.properties = props;
    }

    private static List<UriMapping> parseMappings(Properties props) {
        ArrayList<UriMapping> mappings = new ArrayList<UriMapping>();
        Collection<String> mappingsParam = Parameters.MAPPINGS.getValue(props);
        for (String mappingParam : mappingsParam) {
            mappings.add(UriMapping.create(mappingParam));
        }
        return mappings;
    }

    private BaseUrlRetrieveStrategy getBaseUrlRetrieveSession(Properties props) {
        BaseUrlRetrieveStrategy urlStrategy;
        String[] baseURLs = Parameters.REMOTE_URL_BASE.getValue(props);
        if (baseURLs.length == 0) {
            throw new ConfigurationException(Parameters.REMOTE_URL_BASE.getName() + " property cannot be empty for instance '" + this.instanceName + "'");
        }
        if (baseURLs.length == 1) {
            urlStrategy = new SingleBaseUrlRetrieveStrategy(baseURLs[0]);
        } else {
            String strategy = Parameters.REMOTE_URL_BASE_STRATEGY.getValue(props);
            if ("roundrobin".equalsIgnoreCase(strategy)) {
                urlStrategy = new RoundRobinBaseUrlRetrieveStrategy(baseURLs);
            } else if ("iphash".equalsIgnoreCase(strategy)) {
                urlStrategy = new IpHashBaseUrlRetrieveStrategy(baseURLs);
            } else if ("stickysession".equalsIgnoreCase(strategy)) {
                urlStrategy = new StickySessionBaseUrlRetrieveStrategy(baseURLs);
            } else {
                throw new ConfigurationException("No such BaseUrlRetrieveStrategy '" + strategy + "'");
            }
        }
        return urlStrategy;
    }

    public String getVisibleBaseURL() {
        return this.visibleBaseURL;
    }

    public boolean isPreserveHost() {
        return this.preserveHost;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getUriEncoding() {
        return this.uriEncoding;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public BaseUrlRetrieveStrategy getBaseUrlRetrieveStrategy() {
        return this.baseUrlRetrieveStrategy;
    }

    public List<UriMapping> getUriMappings() {
        return this.uriMappings;
    }

    public boolean isStripMappingPath() {
        return this.stripMappingPath;
    }
}

