/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.vars;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequest;
import org.apache.http.cookie.Cookie;
import org.esigate.ConfigurationException;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.http.IncomingRequest;
import org.esigate.impl.DriverRequest;
import org.esigate.util.HttpRequestHelper;
import org.esigate.util.UriUtils;
import org.esigate.vars.VarUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VariablesResolver {
    private static final Logger LOG = LoggerFactory.getLogger(VariablesResolver.class);
    private static Pattern userAgentVersion = Pattern.compile("^[A-Za-z]+/([0-9]+\\.[0-9]+)");
    private static Properties properties;
    private static final Pattern VAR_PATTERN;

    private VariablesResolver() {
    }

    public static void configure(Properties props) {
        properties = props;
    }

    public static void configure() {
        InputStream inputStream = null;
        try {
            LOG.debug("Loading esigate-vars.properties file");
            inputStream = Driver.class.getResourceAsStream("/esigate-vars.properties");
            if (inputStream == null) {
                inputStream = Driver.class.getResourceAsStream("vars.properties");
            }
            if (inputStream != null) {
                properties = new Properties();
                properties.load(inputStream);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static URL getVariablessUrl() {
        URL varsUrl = Driver.class.getResource("/esigate-vars.properties");
        if (varsUrl == null) {
            varsUrl = Driver.class.getResource("vars.properties");
        }
        return varsUrl;
    }

    static boolean containsVariable(String strVars) {
        return strVars.contains("$(") && strVars.contains(")");
    }

    public static String replaceAllVariables(String strVars) {
        return VariablesResolver.replaceAllVariables(strVars, null);
    }

    public static String replaceAllVariables(String strVars, DriverRequest request) {
        String result = strVars;
        if (VariablesResolver.containsVariable(strVars)) {
            Matcher matcher = VAR_PATTERN.matcher(strVars);
            while (matcher.find()) {
                String value;
                String group = matcher.group();
                String var = group.substring(2, group.length() - 1);
                String arg = null;
                int argIndex = var.indexOf(123);
                if (argIndex != -1) {
                    arg = VarUtils.removeSimpleQuotes(var.substring(argIndex + 1, var.indexOf(125)));
                }
                String defaultValue = "";
                int defaultValueIndex = var.indexOf(124);
                if (defaultValueIndex != -1) {
                    defaultValue = VarUtils.removeSimpleQuotes(var.substring(defaultValueIndex + 1));
                }
                if ((value = VariablesResolver.getProperty(var, arg, request)) == null) {
                    value = defaultValue;
                }
                result = result.replace(group, value);
            }
        }
        return result;
    }

    private static String getProperty(String var, String arg, DriverRequest request) {
        String result = VariablesResolver.processVar(var, arg, request);
        if (properties != null) {
            result = properties.getProperty(var, result);
        }
        LOG.debug("Resolve property $({})={}", (Object)var, (Object)result);
        return result;
    }

    private static String processVar(String var, String arg, DriverRequest request) {
        IncomingRequest incomingRequest = null;
        if (request != null) {
            incomingRequest = request.getOriginalRequest();
        }
        String res = null;
        if (var.contains("QUERY_STRING")) {
            res = arg == null ? UriUtils.getRawQuery(incomingRequest.getRequestLine().getUri()) : HttpRequestHelper.getParameter(request, arg);
        } else if (var.contains("HTTP_ACCEPT_LANGUAGE")) {
            String langs = HttpRequestHelper.getFirstHeader("Accept-Language", (HttpRequest)incomingRequest);
            res = arg == null ? langs : String.valueOf(langs != null && langs.contains(arg));
        } else if (var.contains("HTTP_HEADER")) {
            res = HttpRequestHelper.getFirstHeader(arg, (HttpRequest)incomingRequest);
        } else if (var.contains("HTTP_HOST")) {
            res = HttpRequestHelper.getFirstHeader("Host", (HttpRequest)incomingRequest);
        } else if (var.contains("HTTP_REFERER")) {
            res = HttpRequestHelper.getFirstHeader("Referer", (HttpRequest)incomingRequest);
        } else if (var.contains("HTTP_COOKIE")) {
            if (arg == null) {
                String cookieHeaderValue = "";
                for (Cookie c : request.getOriginalRequest().getCookies()) {
                    if (StringUtils.isNotBlank((CharSequence)cookieHeaderValue)) {
                        cookieHeaderValue = cookieHeaderValue + "; ";
                    }
                    cookieHeaderValue = cookieHeaderValue + c.getName() + "=" + c.getValue();
                }
                if (StringUtils.isNotBlank((CharSequence)cookieHeaderValue)) {
                    res = cookieHeaderValue;
                }
            } else {
                Cookie[] cookies;
                for (Cookie c : cookies = request.getOriginalRequest().getCookies()) {
                    if (!c.getName().equals(arg)) continue;
                    res = c.getValue();
                    break;
                }
            }
        } else if (var.contains("HTTP_USER_AGENT")) {
            if (arg == null) {
                res = HttpRequestHelper.getFirstHeader("User-agent", (HttpRequest)incomingRequest);
            } else {
                Matcher m;
                String userAgent = StringUtils.defaultString((String)HttpRequestHelper.getFirstHeader("User-Agent", (HttpRequest)incomingRequest)).toLowerCase();
                if (arg.equals("os")) {
                    res = userAgent.contains("unix") ? "UNIX" : (userAgent.contains("mac") ? "MAC" : (userAgent.contains("windows") ? "WIN" : "OTHER"));
                } else if (arg.equals("browser")) {
                    res = userAgent.contains("msie") ? "MSIE" : "MOZILLA";
                } else if (arg.equals("version") && (m = userAgentVersion.matcher(userAgent)).find()) {
                    res = m.group(1);
                }
            }
        } else if (var.contains("PROVIDER")) {
            String providerUrl = "";
            try {
                Driver driver = DriverFactory.getInstance(arg);
                providerUrl = driver.getConfiguration().getBaseUrlRetrieveStrategy().getBaseURL(request.getOriginalRequest());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return providerUrl;
        }
        return res;
    }

    static {
        VariablesResolver.configure();
        VAR_PATTERN = Pattern.compile("\\$\\((.*?)\\)");
    }
}

