/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.xml;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.dom.Dom2Sax;
import nu.validator.htmlparser.dom.HtmlDocumentBuilder;
import org.esigate.Renderer;
import org.esigate.impl.DriverRequest;
import org.esigate.xml.HtmlNamespaceContext;
import org.esigate.xml.ProcessingFailedException;
import org.esigate.xml.XhtmlSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XpathRenderer
implements Renderer {
    private static final HtmlNamespaceContext HTML_NAMESPACE_CONTEXT = new HtmlNamespaceContext();
    private static final XPathFactory X_PATH_FACTORY = XPathFactory.newInstance();
    private final XPathExpression expr;

    public XpathRenderer(String xpath) {
        try {
            XPath xpathObj = X_PATH_FACTORY.newXPath();
            xpathObj.setNamespaceContext(HTML_NAMESPACE_CONTEXT);
            this.expr = xpathObj.compile(xpath);
        }
        catch (XPathExpressionException e) {
            throw new ProcessingFailedException("failed to compile XPath expression", e);
        }
    }

    @Override
    public void render(DriverRequest httpRequest, String src, Writer out) throws IOException {
        try {
            HtmlDocumentBuilder htmlDocumentBuilder = new HtmlDocumentBuilder();
            htmlDocumentBuilder.setDoctypeExpectation(DoctypeExpectation.NO_DOCTYPE_ERRORS);
            Document document = htmlDocumentBuilder.parse(new InputSource(new StringReader(src)));
            NodeList matchingNodes = (NodeList)this.expr.evaluate(document, XPathConstants.NODESET);
            XhtmlSerializer serializer = new XhtmlSerializer(out);
            Dom2Sax dom2Sax = new Dom2Sax((ContentHandler)((Object)serializer), (LexicalHandler)((Object)serializer));
            for (int i = 0; i < matchingNodes.getLength(); ++i) {
                dom2Sax.parse(matchingNodes.item(i));
            }
        }
        catch (XPathExpressionException e) {
            throw new ProcessingFailedException("Failed to evaluate XPath expression", e);
        }
        catch (SAXException e) {
            throw new ProcessingFailedException("Unable to parse source", e);
        }
    }
}

