/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.url;

import java.util.concurrent.atomic.AtomicInteger;
import org.esigate.api.BaseUrlRetrieveStrategy;
import org.esigate.http.IncomingRequest;

public class RoundRobinBaseUrlRetrieveStrategy
implements BaseUrlRetrieveStrategy {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final String[] urls;

    public RoundRobinBaseUrlRetrieveStrategy(String[] urls) {
        this.urls = urls;
    }

    @Override
    public String getBaseURL(IncomingRequest originalRequest) {
        int incremented = this.counter.incrementAndGet();
        int index = incremented % this.urls.length;
        return this.urls[Math.abs(index)];
    }
}

