/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.test;

import java.io.IOException;
import java.util.Properties;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.message.BasicRequestLine;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.api.ContainerRequestContext;
import org.esigate.http.HttpClientRequestExecutor;
import org.esigate.http.IncomingRequest;
import org.esigate.impl.DriverRequest;
import org.esigate.test.MockSession;
import org.esigate.test.conn.IResponseHandler;
import org.esigate.test.conn.MockConnectionManager;
import org.esigate.test.http.HttpResponseBuilder;
import org.esigate.util.UriUtils;

public final class TestUtils {
    private TestUtils() {
    }

    public static IncomingRequest.Builder createIncomingRequest(String uri) {
        HttpHost httpHost = UriUtils.extractHost(uri);
        String scheme = httpHost.getSchemeName();
        String host = httpHost.getHostName();
        int port = httpHost.getPort();
        BasicRequestLine requestLine = new BasicRequestLine("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        IncomingRequest.Builder builder = IncomingRequest.builder((RequestLine)requestLine);
        builder.setContext(new ContainerRequestContext(){});
        if (port == -1 || port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme)) {
            builder.addHeader("Host", host);
        } else {
            builder.addHeader("Host", host + ":" + port);
        }
        builder.setSession(new MockSession());
        return builder;
    }

    public static IncomingRequest.Builder createIncomingRequest() {
        return TestUtils.createIncomingRequest("http://localhost:8080");
    }

    public static DriverRequest createDriverRequest(String uri, Driver driver) throws HttpErrorPage {
        IncomingRequest request = TestUtils.createIncomingRequest(uri).build();
        return new DriverRequest(request, driver, "/");
    }

    public static DriverRequest createDriverRequest(Driver driver) throws HttpErrorPage {
        IncomingRequest request = TestUtils.createIncomingRequest().build();
        return new DriverRequest(request, driver, "/");
    }

    public static Driver createMockDriver(Properties properties, IResponseHandler responseHandler) {
        MockConnectionManager connManager = new MockConnectionManager();
        connManager.setResponseHandler(responseHandler);
        return TestUtils.createMockDriver(properties, connManager);
    }

    public static Driver createMockDriver(Properties properties, HttpResponse response) {
        MockConnectionManager connManager = new MockConnectionManager();
        connManager.setResponse(response);
        return TestUtils.createMockDriver(properties, connManager);
    }

    public static Driver createMockDriver(Properties properties, HttpClientConnectionManager connectionManager) {
        return TestUtils.createMockDriver(properties, connectionManager, "tested");
    }

    public static Driver createMockDriver(Properties properties, HttpClientConnectionManager connectionManager, String name) {
        Driver driver = Driver.builder().setName(name).setProperties(properties).setRequestExecutorBuilder(HttpClientRequestExecutor.builder().setConnectionManager(connectionManager)).build();
        DriverFactory.put(name, driver);
        return driver;
    }

    public static HttpResponseBuilder createHttpResponse() {
        return new HttpResponseBuilder();
    }

    public static IncomingRequest.Builder createRequest(String uri) {
        return TestUtils.createIncomingRequest(uri);
    }

    public static CloseableHttpResponse driverProxy(Driver d, IncomingRequest request, Renderer ... renderers) throws IOException, HttpErrorPage {
        String uri = request.getRequestLine().getUri();
        return d.proxy(UriUtils.getPath(uri), request, renderers);
    }
}

