/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.tags;

import java.io.IOException;
import org.esigate.aggregator.AggregationSyntaxException;
import org.esigate.parser.Element;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContext;
import org.esigate.tags.BlockRenderer;

class BlockElement
implements Element {
    public static final ElementType TYPE = new ElementType(){

        @Override
        public boolean isStartTag(String tag) {
            return tag.startsWith("<!--$beginblock$");
        }

        @Override
        public boolean isEndTag(String tag) {
            return tag.startsWith("<!--$endblock$");
        }

        @Override
        public Element newInstance() {
            return new BlockElement();
        }
    };
    private BlockRenderer blockRenderer;
    private boolean nameMatches;

    BlockElement() {
    }

    @Override
    public boolean onError(Exception e, ParserContext ctx) {
        return false;
    }

    @Override
    public void onTagEnd(String tag, ParserContext ctx) {
        if (this.nameMatches) {
            this.blockRenderer.setWrite(false);
        }
    }

    @Override
    public void onTagStart(String tag, ParserContext ctx) {
        String[] parameters = tag.split("\\$");
        if (parameters.length != 4) {
            throw new AggregationSyntaxException("Invalid syntax: " + tag);
        }
        String name = parameters[2];
        this.blockRenderer = ctx.findAncestor(BlockRenderer.class);
        this.nameMatches = name.equals(this.blockRenderer.getName());
        if (this.nameMatches) {
            this.blockRenderer.setWrite(true);
        }
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void characters(CharSequence csq, int start, int end) throws IOException {
        this.blockRenderer.append(csq, start, end);
    }
}

