/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectStrategy
extends DefaultRedirectStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RedirectStrategy.class);
    private static final String LAST_REQUEST = "LAST_REQUEST";

    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        HttpUriRequest newRequest = super.getRedirect(request, response, context);
        context.setAttribute(LAST_REQUEST, (Object)newRequest);
        if (LOG.isInfoEnabled()) {
            LOG.info(request.getRequestLine() + " -> " + response.getStatusLine() + " -> automaticaly following redirect to " + newRequest.getRequestLine());
        }
        return newRequest;
    }

    public static HttpRequest getLastRequest(HttpRequest httpRequest, HttpContext httpContext) {
        HttpRequest lastRedirectionRequest = (HttpRequest)httpContext.getAttribute(LAST_REQUEST);
        if (lastRedirectionRequest != null) {
            return lastRedirectionRequest;
        }
        return httpRequest;
    }
}

