/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.message.BasicHttpResponse;
import org.esigate.http.BasicCloseableHttpResponse;
import org.esigate.http.HttpResponseUtils;
import org.esigate.http.OutgoingRequest;
import org.esigate.impl.DriverRequest;
import org.esigate.impl.UrlRewriter;
import org.esigate.util.FilterList;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderManager {
    private static final Logger LOG = LoggerFactory.getLogger(HeaderManager.class);
    private final FilterList requestHeadersFilterList = new FilterList();
    private final FilterList responseHeadersFilterList = new FilterList();
    private final UrlRewriter urlRewriter;

    public HeaderManager(UrlRewriter urlRewriter) {
        this.urlRewriter = urlRewriter;
        this.requestHeadersFilterList.add("*");
        this.requestHeadersFilterList.remove("Connection");
        this.requestHeadersFilterList.remove("Content-Length");
        this.requestHeadersFilterList.remove("Cache-control");
        this.requestHeadersFilterList.remove("Cookie");
        this.requestHeadersFilterList.remove("Host");
        this.requestHeadersFilterList.remove("Max-Forwards");
        this.requestHeadersFilterList.remove("Pragma");
        this.requestHeadersFilterList.remove("Proxy-Authorization");
        this.requestHeadersFilterList.remove("TE");
        this.requestHeadersFilterList.remove("Trailer");
        this.requestHeadersFilterList.remove("Transfer-Encoding");
        this.requestHeadersFilterList.remove("Upgrade");
        this.responseHeadersFilterList.add("*");
        this.responseHeadersFilterList.remove("Connection");
        this.responseHeadersFilterList.remove("Content-Length");
        this.responseHeadersFilterList.remove("Content-MD5");
        this.responseHeadersFilterList.remove("Date");
        this.responseHeadersFilterList.remove("Keep-Alive");
        this.responseHeadersFilterList.remove("Proxy-Authenticate");
        this.responseHeadersFilterList.remove("Set-Cookie");
        this.responseHeadersFilterList.remove("Trailer");
        this.responseHeadersFilterList.remove("Transfer-Encoding");
    }

    protected boolean isForwardedRequestHeader(String headerName) {
        return this.requestHeadersFilterList.contains(headerName);
    }

    protected boolean isForwardedResponseHeader(String headerName) {
        return this.responseHeadersFilterList.contains(headerName);
    }

    public void copyHeaders(DriverRequest originalRequest, HttpRequest httpRequest) {
        String baseUrl = originalRequest.getBaseUrl().toString();
        String visibleBaseUrl = originalRequest.getVisibleBaseUrl();
        for (Header header : originalRequest.getOriginalRequest().getAllHeaders()) {
            String name = header.getName();
            if ("Referer".equalsIgnoreCase(name) && this.isForwardedRequestHeader("Referer")) {
                String value = header.getValue();
                value = this.urlRewriter.rewriteReferer(value, baseUrl, visibleBaseUrl);
                httpRequest.addHeader(name, value);
                continue;
            }
            if (!this.isForwardedRequestHeader(name)) continue;
            httpRequest.addHeader(header);
        }
        String remoteAddr = originalRequest.getOriginalRequest().getRemoteAddr();
        if (remoteAddr != null) {
            String forwardedFor = null;
            if (httpRequest.containsHeader("X-Forwarded-For")) {
                forwardedFor = httpRequest.getFirstHeader("X-Forwarded-For").getValue();
            }
            forwardedFor = forwardedFor == null ? remoteAddr : forwardedFor + ", " + remoteAddr;
            httpRequest.setHeader("X-Forwarded-For", forwardedFor);
        }
        if (!httpRequest.containsHeader("X-Forwarded-Proto")) {
            httpRequest.addHeader("X-Forwarded-Proto", UriUtils.extractScheme(originalRequest.getOriginalRequest().getRequestLine().getUri()));
        }
    }

    public CloseableHttpResponse copyHeaders(OutgoingRequest outgoingRequest, HttpEntityEnclosingRequest incomingRequest, HttpResponse httpClientResponse) {
        BasicHttpResponse result = new BasicHttpResponse(httpClientResponse.getStatusLine());
        result.setEntity(httpClientResponse.getEntity());
        String originalUri = incomingRequest.getRequestLine().getUri();
        String baseUrl = outgoingRequest.getBaseUrl().toString();
        String visibleBaseUrl = outgoingRequest.getOriginalRequest().getVisibleBaseUrl();
        for (Header header : httpClientResponse.getAllHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            try {
                if ("Content-Encoding".equalsIgnoreCase(name) || !this.isForwardedResponseHeader(name)) continue;
                if ("Location".equalsIgnoreCase(name) || "Content-Location".equalsIgnoreCase(name)) {
                    value = this.urlRewriter.rewriteUrl(value, originalUri, baseUrl, visibleBaseUrl, true);
                    value = HttpResponseUtils.removeSessionId(value, httpClientResponse);
                    result.addHeader(name, value);
                    continue;
                }
                if ("Link".equalsIgnoreCase(name)) {
                    if (value.startsWith("<") && value.contains(">")) {
                        String urlValue = value.substring(1, value.indexOf(">"));
                        String targetUrlValue = this.urlRewriter.rewriteUrl(urlValue, originalUri, baseUrl, visibleBaseUrl, true);
                        targetUrlValue = HttpResponseUtils.removeSessionId(targetUrlValue, httpClientResponse);
                        value = value.replace("<" + urlValue + ">", "<" + targetUrlValue + ">");
                    }
                    result.addHeader(name, value);
                    continue;
                }
                if ("Refresh".equalsIgnoreCase(name)) {
                    int urlPosition = value.indexOf("url=");
                    if (urlPosition >= 0) {
                        value = this.urlRewriter.rewriteRefresh(value, originalUri, baseUrl, visibleBaseUrl);
                        value = HttpResponseUtils.removeSessionId(value, httpClientResponse);
                    }
                    result.addHeader(name, value);
                    continue;
                }
                if ("P3p".equalsIgnoreCase(name)) {
                    result.addHeader(name, value);
                    continue;
                }
                result.addHeader(header.getName(), header.getValue());
            }
            catch (Exception e1) {
                LOG.error("Error while copying headers", (Throwable)e1);
                result.addHeader("X-Esigate-Error", "Error processing header " + name + ": " + value);
            }
        }
        return BasicCloseableHttpResponse.adapt((HttpResponse)result);
    }
}

