/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.esigate.Driver;
import org.esigate.esi.EsiRenderer;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.RenderEvent;
import org.esigate.extension.Extension;
import org.esigate.extension.surrogate.CapabilitiesEvent;
import org.esigate.extension.surrogate.Surrogate;

public class Esi
implements Extension,
IEventListener {
    private static final String[] CAPABILITIES = new String[]{"ESI/1.0", "ESI-Inline/1.0", "X-ESI-Fragment/1.0", "X-ESI-Replace/1.0", "X-ESI-XSLT/1.0", "ESIGATE/4.0"};

    @Override
    public boolean event(EventDefinition id, Event event) {
        RenderEvent renderEvent = (RenderEvent)event;
        boolean doEsi = true;
        if (renderEvent.getHttpResponse() != null && renderEvent.getHttpResponse().containsHeader("X-Esigate-Internal-Enabled-Capabilities")) {
            String enabledCapabilities = renderEvent.getHttpResponse().getFirstHeader("X-Esigate-Internal-Enabled-Capabilities").getValue();
            doEsi = false;
            for (String capability : CAPABILITIES) {
                if (!StringUtils.containsIgnoreCase((CharSequence)enabledCapabilities, (CharSequence)capability)) continue;
                doEsi = true;
                break;
            }
        }
        if (doEsi) {
            renderEvent.getRenderers().add(new EsiRenderer());
        }
        return true;
    }

    @Override
    public void init(Driver driver, Properties properties) {
        driver.getEventManager().register(EventManager.EVENT_RENDER_PRE, this);
        driver.getEventManager().register(Surrogate.EVENT_SURROGATE_CAPABILITIES, new IEventListener(){

            @Override
            public boolean event(EventDefinition id, Event event) {
                CapabilitiesEvent capEvent = (CapabilitiesEvent)event;
                for (String capability : CAPABILITIES) {
                    capEvent.getCapabilities().add(capability);
                }
                return true;
            }
        });
    }
}

