/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.esi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.esigate.Driver;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.esi.BaseElement;
import org.esigate.esi.BaseElementType;
import org.esigate.esi.EsiRenderer;
import org.esigate.esi.InlineCache;
import org.esigate.esi.Tag;
import org.esigate.http.HttpResponseUtils;
import org.esigate.impl.DriverRequest;
import org.esigate.parser.Adapter;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContext;
import org.esigate.xml.XpathRenderer;
import org.esigate.xml.XsltRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IncludeElement
extends BaseElement {
    private static final String PROVIDER_PATTERN = "$(PROVIDER{";
    private static final String LEGACY_PROVIDER_PATTERN = "$PROVIDER({";
    private static final Logger LOG = LoggerFactory.getLogger(IncludeElement.class);
    public static final ElementType TYPE = new BaseElementType("<esi:include", "</esi:include"){

        @Override
        public IncludeElement newInstance() {
            return new IncludeElement();
        }
    };
    private final Appendable outAdapter = new Adapter(this);
    private StringBuilder buf;
    private Map<String, CharSequence> fragmentReplacements;
    private Map<String, CharSequence> regexpReplacements;
    private Tag includeTag;
    private boolean write = false;

    IncludeElement() {
    }

    @Override
    public void characters(CharSequence csq, int start, int end) {
        if (this.write) {
            this.buf.append(csq, start, end);
        }
    }

    @Override
    public void onTagEnd(String tag, ParserContext ctx) throws IOException, HttpErrorPage {
        this.write = true;
        String src = this.includeTag.getAttribute("src");
        String alt = this.includeTag.getAttribute("alt");
        boolean ignoreError = "continue".equals(this.includeTag.getAttribute("onerror"));
        Exception currentException = null;
        try {
            this.processPage(src, this.includeTag, ctx);
        }
        catch (IOException | HttpErrorPage e) {
            currentException = e;
        }
        if (currentException != null && alt != null) {
            currentException = null;
            try {
                this.processPage(alt, this.includeTag, ctx);
            }
            catch (IOException | HttpErrorPage e) {
                currentException = e;
            }
        }
        if (currentException != null && !ignoreError && !ctx.reportError(currentException)) {
            if (currentException instanceof IOException) {
                throw (IOException)currentException;
            }
            if (currentException instanceof HttpErrorPage) {
                throw (HttpErrorPage)currentException;
            }
            throw new IllegalStateException("This type of exception is unexpected here. Should be IOException or HttpErrorPageException.", currentException);
        }
        if (!this.regexpReplacements.isEmpty()) {
            for (Map.Entry<String, CharSequence> entry : this.regexpReplacements.entrySet()) {
                this.buf = new StringBuilder(Pattern.compile(entry.getKey()).matcher(this.buf).replaceAll(entry.getValue().toString()));
            }
        }
        ctx.getCurrent().characters(this.buf, 0, this.buf.length());
    }

    @Override
    protected void parseTag(Tag tag, ParserContext ctx) {
        this.buf = new StringBuilder(1024);
        this.fragmentReplacements = new HashMap<String, CharSequence>();
        this.regexpReplacements = new HashMap<String, CharSequence>();
        this.includeTag = tag;
    }

    private void processPage(String src, Tag tag, ParserContext ctx) throws IOException, HttpErrorPage {
        String provider;
        int endIndex;
        int startIdx;
        Driver driver;
        String page;
        String fragment = tag.getAttribute("fragment");
        String xpath = tag.getAttribute("xpath");
        String xslt = tag.getAttribute("stylesheet");
        DriverRequest httpRequest = ctx.getHttpRequest();
        ArrayList<Renderer> rendererList = new ArrayList<Renderer>();
        int idx = src.indexOf(PROVIDER_PATTERN);
        int idxLegacyPattern = src.indexOf(LEGACY_PROVIDER_PATTERN);
        if (idx < 0 && idxLegacyPattern < 0) {
            page = src;
            driver = httpRequest.getDriver();
        } else if (idx >= 0) {
            startIdx = idx + PROVIDER_PATTERN.length();
            endIndex = src.indexOf("})", startIdx);
            provider = src.substring(startIdx, endIndex);
            page = src.substring(endIndex + "})".length());
            driver = DriverFactory.getInstance(provider);
            if (LOG.isWarnEnabled() && idx > 0) {
                LOG.warn("Invalid src attribute : [{}], src should start with [{}{}})]. First characters [{}] have been ignored", new Object[]{src, PROVIDER_PATTERN, provider, src.substring(0, idx)});
            }
        } else {
            startIdx = idxLegacyPattern + PROVIDER_PATTERN.length();
            endIndex = src.indexOf("})", startIdx);
            provider = src.substring(startIdx, endIndex);
            page = src.substring(endIndex + "})".length());
            driver = DriverFactory.getInstance(provider);
            if (LOG.isWarnEnabled() && idxLegacyPattern > 0) {
                LOG.warn("Invalid src attribute : [{}], src should start with [{}{}})]. First characters [{}] have been ignored", new Object[]{src, PROVIDER_PATTERN, provider, src.substring(0, idxLegacyPattern)});
            }
        }
        InlineCache ic = InlineCache.getFragment(src);
        if (ic != null && !ic.isExpired()) {
            String cache = ic.getFragment();
            this.characters(cache, 0, cache.length());
        } else {
            EsiRenderer esiRenderer = fragment != null ? new EsiRenderer(page, fragment) : new EsiRenderer();
            if (this.fragmentReplacements != null && !this.fragmentReplacements.isEmpty()) {
                esiRenderer.setFragmentsToReplace(this.fragmentReplacements);
            }
            rendererList.add(esiRenderer);
            if (xpath != null) {
                rendererList.add(new XpathRenderer(xpath));
            } else if (xslt != null) {
                rendererList.add(new XsltRenderer(xslt, driver, httpRequest));
            }
            CloseableHttpResponse response = driver.render(page, httpRequest.getOriginalRequest(), rendererList.toArray(new Renderer[rendererList.size()]));
            this.outAdapter.append(HttpResponseUtils.toString(response));
        }
    }

    void addFragmentReplacement(String fragment, CharSequence replacement) {
        this.fragmentReplacements.put(fragment, replacement);
    }

    void addRegexpReplacement(String regexp, CharSequence replacement) {
        this.regexpReplacements.put(regexp, replacement);
    }
}

