/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.Serializable;
import org.esigate.api.Session;
import org.esigate.http.IncomingRequest;

public class UserContext {
    private static final String USER_KEY = "user";
    private final IncomingRequest httpRequest;
    private final String key;

    public UserContext(IncomingRequest httpRequest, String key) {
        this.httpRequest = httpRequest;
        this.key = UserContext.class.getName() + "#" + key;
    }

    private String prefixAttributeName(String name) {
        return this.key + "#" + name;
    }

    public Object getAttribute(String name) {
        Session session = this.httpRequest.getSession();
        if (session == null) {
            return null;
        }
        return session.getAttribute(this.prefixAttributeName(name));
    }

    public void setAttribute(String name, Serializable value) {
        this.httpRequest.getSession().setAttribute(this.prefixAttributeName(name), value);
    }

    public String getUser() {
        return (String)this.getAttribute(USER_KEY);
    }

    public void setUser(String user) {
        this.setAttribute(USER_KEY, (Serializable)((Object)user));
    }

    public String toString() {
        StringBuilder result = new StringBuilder(256).append("User=").append(this.getUser());
        return result.toString();
    }

    public static String getUserSessionKey(String providerName) {
        return UserContext.class.getName() + "#" + providerName + "#" + USER_KEY;
    }
}

