/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.util.EntityUtils;
import org.esigate.http.BasicCloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpErrorPage
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HttpErrorPage.class);
    private final CloseableHttpResponse httpResponse;

    private static HttpEntity toMemoryEntity(String content) {
        return new StringEntity(content, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpEntity toMemoryEntity(Exception exception) {
        StringBuilderWriter out = new StringBuilderWriter(1024);
        PrintWriter pw = new PrintWriter((Writer)out);
        exception.printStackTrace(pw);
        String content = out.toString();
        try {
            HttpEntity httpEntity = HttpErrorPage.toMemoryEntity(content);
            return httpEntity;
        }
        finally {
            pw.close();
        }
    }

    private static HttpEntity toMemoryEntity(HttpEntity httpEntity) {
        ByteArrayEntity memoryEntity;
        if (httpEntity == null) {
            return null;
        }
        try {
            byte[] content = EntityUtils.toByteArray((HttpEntity)httpEntity);
            ByteArrayEntity byteArrayEntity = new ByteArrayEntity(content, ContentType.get((HttpEntity)httpEntity));
            Header contentEncoding = httpEntity.getContentEncoding();
            if (contentEncoding != null) {
                byteArrayEntity.setContentEncoding(contentEncoding);
            }
            memoryEntity = byteArrayEntity;
        }
        catch (IOException e) {
            StringBuilderWriter out = new StringBuilderWriter(1024);
            PrintWriter pw = new PrintWriter((Writer)out);
            e.printStackTrace(pw);
            pw.close();
            memoryEntity = new StringEntity(out.toString(), ContentType.getOrDefault((HttpEntity)httpEntity));
        }
        return memoryEntity;
    }

    public HttpErrorPage(CloseableHttpResponse httpResponse) {
        super(httpResponse.getStatusLine().getStatusCode() + " " + httpResponse.getStatusLine().getReasonPhrase());
        this.httpResponse = httpResponse;
        httpResponse.setEntity(HttpErrorPage.toMemoryEntity(httpResponse.getEntity()));
    }

    public HttpErrorPage(int statusCode, String statusMessage, String content) {
        super(statusCode + " " + statusMessage);
        this.httpResponse = HttpErrorPage.generateHttpResponse(statusCode, statusMessage);
        this.httpResponse.setEntity(HttpErrorPage.toMemoryEntity(content));
    }

    public HttpErrorPage(int statusCode, String statusMessage, Exception exception) {
        super(statusCode + " " + statusMessage, exception);
        this.httpResponse = HttpErrorPage.generateHttpResponse(statusCode, statusMessage);
        this.httpResponse.setEntity(HttpErrorPage.toMemoryEntity(exception));
    }

    public CloseableHttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public static CloseableHttpResponse generateHttpResponse(Exception exception) {
        if (exception instanceof HttpHostConnectException) {
            return HttpErrorPage.generateHttpResponse(502, "Connection refused");
        }
        if (exception instanceof ConnectionPoolTimeoutException) {
            return HttpErrorPage.generateHttpResponse(504, "Connection pool timeout");
        }
        if (exception instanceof ConnectTimeoutException) {
            return HttpErrorPage.generateHttpResponse(504, "Connect timeout");
        }
        if (exception instanceof SocketTimeoutException) {
            return HttpErrorPage.generateHttpResponse(504, "Socket timeout");
        }
        if (exception instanceof SocketException) {
            return HttpErrorPage.generateHttpResponse(502, "Socket Exception");
        }
        if (exception instanceof ClientProtocolException) {
            String message = exception.getMessage();
            if (message == null && exception.getCause() != null) {
                message = exception.getCause().getMessage();
            }
            return HttpErrorPage.generateHttpResponse(502, "Protocol error: " + message);
        }
        LOG.error("Error retrieving URL", (Throwable)exception);
        return HttpErrorPage.generateHttpResponse(502, "Error retrieving URL");
    }

    public static CloseableHttpResponse generateHttpResponse(int statusCode, String statusText) {
        CloseableHttpResponse result = BasicCloseableHttpResponse.adapt((HttpResponse)new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusText)));
        result.setEntity(HttpErrorPage.toMemoryEntity(statusText));
        return result;
    }
}

